/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.hudmanage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.class_310;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;
import org.ashmeetop.feather_remake.client.hudmanage.HudPresetData;

public class HudPresetManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File HUDS_DIR = new File(class_310.method_1551().field_1697, "config/feather_remake/huds");

    public static void save(HudElement element) {
        File file = new File(HUDS_DIR, element.getName() + ".json");
        HudPresetData data = new HudPresetData(element);
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void load(HudElement element) {
        File file = new File(HUDS_DIR, element.getName() + ".json");
        if (!file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(file);){
            HudPresetData data = (HudPresetData)GSON.fromJson((Reader)reader, HudPresetData.class);
            if (data != null) {
                data.applyTo(element);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        if (!HUDS_DIR.exists()) {
            HUDS_DIR.mkdirs();
        }
    }
}

