/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.motionblur;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_310;

public class ShaderUtils {
    private static boolean motionBlurEnabled = true;
    private static class_304 toggleShaderKey;

    public static void init() {
        ShaderUtils.ensureShaderPackExists();
        ShaderUtils.loadIrisShaderPack();
        toggleShaderKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Toggle Motion Blur Shader", 80, "feather general"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (toggleShaderKey.method_1436()) {
                ShaderUtils.toggleMotionBlur();
            }
        });
    }

    private static void ensureShaderPackExists() {
        block10: {
            try {
                Path shadersDir = Path.of(class_310.method_1551().field_1697.getAbsolutePath(), "shaderpacks");
                Files.createDirectories(shadersDir, new FileAttribute[0]);
                Path zipPath = shadersDir.resolve("feather_motion_blur.zip");
                if (Files.exists(zipPath, new LinkOption[0])) break block10;
                try (InputStream is = ShaderUtils.class.getResourceAsStream("/assets/feather_remake/shaders/feather_motion_blur.zip");){
                    if (is != null) {
                        Files.copy(is, zipPath, StandardCopyOption.REPLACE_EXISTING);
                        System.out.println("Shader pack copied to shaderpacks folder!");
                    } else {
                        System.err.println("Cannot find feather_motion_blur.zip in mod resources!");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void loadIrisShaderPack() {
        try {
            Class<?> irisManagerClass = Class.forName("net.coderbot.iris.api.IrisShaderManager");
            Object irisManager = irisManagerClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Method loadPackMethod = irisManagerClass.getMethod("loadShaderPack", String.class);
            loadPackMethod.invoke(irisManager, "feather_motion_blur.zip");
            System.out.println("Iris shader pack loaded successfully!");
        }
        catch (ClassNotFoundException e) {
            System.out.println("Iris not found, skipping shader load.");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void toggleMotionBlur() {
        motionBlurEnabled = !motionBlurEnabled;
        try {
            Class<?> irisManagerClass = Class.forName("net.coderbot.iris.api.IrisShaderManager");
            Object irisManager = irisManagerClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Method getPassMethod = irisManagerClass.getMethod("getPass", String.class);
            Object pass = getPassMethod.invoke(irisManager, "motion_blur");
            if (pass != null) {
                Method setEnabledMethod = pass.getClass().getMethod("setEnabled", Boolean.TYPE);
                setEnabledMethod.invoke(pass, motionBlurEnabled);
                System.out.println("Motion blur " + (motionBlurEnabled ? "enabled" : "disabled"));
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Iris not found, cannot toggle motion blur.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

