/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.settings;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.class_310;

public class FogSettings {
    public static boolean enabled = false;
    public static Color fogColor = new Color(255, 255, 255);
    private static final Gson GSON = new Gson();
    private static final File CONFIG_FILE = new File(class_310.method_1551().field_1697, "config/feather_remake/fog.json");

    public static void save() {
        try {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(enabled));
            JsonObject color = new JsonObject();
            color.addProperty("r", (Number)fogColor.getRed());
            color.addProperty("g", (Number)fogColor.getGreen());
            color.addProperty("b", (Number)fogColor.getBlue());
            json.add("fogColor", (JsonElement)color);
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save FogSettings: " + e.getMessage());
        }
    }

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            enabled = json.get("enabled").getAsBoolean();
            JsonObject color = json.getAsJsonObject("fogColor");
            int r = color.get("r").getAsInt();
            int g = color.get("g").getAsInt();
            int b = color.get("b").getAsInt();
            fogColor = new Color(r, g, b);
        }
        catch (Exception e) {
            System.err.println("Failed to load FogSettings: " + e.getMessage());
        }
    }
}

