/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.util;

import java.awt.Color;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;

public class ArmorHud
implements HudElement {
    private int x = 10;
    private int y = 10;
    private int width = 70;
    private int height = 80;
    private boolean resizing = false;
    private static final class_2960 RESIZE_HANDLE = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/remove.png");
    private boolean enabled = true;
    private int color = -1;
    private boolean background = true;
    private boolean rgbMode = false;

    @Override
    public void render(class_332 graphics, float tickDelta) {
    }

    @Override
    public void render(class_332 graphics, boolean editing) {
        if (!this.enabled && !editing) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null || client.field_1690.field_1842) {
            return;
        }
        class_327 font = client.field_1772;
        List<class_1799> armor = List.of(player.method_31548().method_5438(39), player.method_31548().method_5438(38), player.method_31548().method_5438(37), player.method_31548().method_5438(36));
        boolean anyArmor = armor.stream().anyMatch(stack -> !stack.method_7960());
        if (!anyArmor && !editing) {
            return;
        }
        int iconSize = 20;
        int availableHeight = this.height;
        int numItems = 4;
        int padding = (availableHeight - iconSize * numItems) / (numItems - 1);
        int drawY = this.y;
        int drawColor = this.color;
        if (this.rgbMode) {
            float hue = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
            drawColor = Color.HSBtoRGB(hue, 1.0f, 1.0f) | 0xFF000000;
        }
        for (class_1799 stack2 : armor) {
            if (stack2.method_7960() && !editing) continue;
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            if (!stack2.method_7960()) {
                graphics.method_51427(stack2, this.x, drawY);
                graphics.method_51431(font, stack2, this.x, drawY);
                if (stack2.method_7986()) {
                    int max = stack2.method_7936();
                    int current = max - stack2.method_7919();
                    String durability = current + "/" + max;
                    graphics.method_51433(font, durability, this.x + iconSize + 4, drawY + 6, drawColor, false);
                }
            }
            graphics.method_51448().method_22909();
            drawY += iconSize + padding;
        }
        if (this.background) {
            int bgWidth = this.width;
            int bgHeight = this.height;
            graphics.method_25294(this.x, this.y, this.x + bgWidth, this.y + bgHeight, -2013265920);
        }
        if (editing) {
            graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, 0x66000000);
            graphics.method_49601(this.x, this.y, this.width, this.height, -7829368);
            String label = "[ ARMOR HUD ]";
            int labelWidth = font.method_1727(label);
            graphics.method_25294(this.x + (this.width - labelWidth) / 2 - 3, this.y - 12, this.x + (this.width + labelWidth) / 2 + 3, this.y - 2, -2013265920);
            graphics.method_51433(font, label, this.x + this.width / 2 - labelWidth / 2, this.y - 10, -1, false);
            int handleSize = 8;
            graphics.method_25290(class_1921::method_62275, RESIZE_HANDLE, this.x + this.width - handleSize, this.y + this.height - handleSize, 0.0f, 0.0f, handleSize, handleSize, handleSize, handleSize);
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    @Override
    public boolean isResizing(double mouseX, double mouseY) {
        int handleSize = 6;
        return mouseX >= (double)(this.x + this.width - handleSize) && mouseX <= (double)(this.x + this.width + 1) && mouseY >= (double)(this.y + this.height - handleSize) && mouseY <= (double)(this.y + this.height + 1);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"feather_remake", (String)"textures/icons/arm.png");
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    @Override
    public void init() {
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setBackground(boolean background) {
        this.background = background;
    }

    @Override
    public boolean hasBackground() {
        return this.background;
    }

    @Override
    public int getIconWidth() {
        return 48;
    }

    @Override
    public int getIconHeight() {
        return 24;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setRgbMode(boolean enabled) {
        this.rgbMode = enabled;
    }

    @Override
    public boolean isRgbMode() {
        return this.rgbMode;
    }

    @Override
    public String getName() {
        return "Armour";
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setResizing(boolean resizing) {
        this.resizing = resizing;
    }

    public boolean isResizing() {
        return this.resizing;
    }
}

