/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.util;

import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;

public class MiniMapHud
implements HudElement {
    private int x = 10;
    private int y = 10;
    private int size = 100;
    private boolean enabled = true;
    private boolean showEntities = true;
    private static final class_2960 MAP_BG = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/minimap_bg.png");
    private int color = -1;
    private boolean background = true;

    @Override
    public void render(class_332 graphics, float tickDelta) {
        this.render(graphics, false);
    }

    @Override
    public void render(class_332 graphics, boolean editing) {
        if (!this.enabled) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null || mc.field_1687 == null) {
            return;
        }
        int cx = this.x + this.size / 2;
        int cy = this.y + this.size / 2;
        graphics.method_51448().method_22903();
        float scale = (float)this.size / 64.0f;
        graphics.method_51448().method_46416((float)this.x, (float)this.y, 0.0f);
        graphics.method_51448().method_22905(scale, scale, 1.0f);
        int radius = 32;
        int playerX = (int)player.method_23317();
        int playerZ = (int)player.method_23321();
        for (int dx = -radius; dx < radius; ++dx) {
            for (int dz = -radius; dz < radius; ++dz) {
                int worldX = playerX + dx;
                int worldZ = playerZ + dz;
                int yTop = mc.field_1687.method_8624(class_2902.class_2903.field_13202, worldX, worldZ);
                class_2338 pos = new class_2338(worldX, yTop - 1, worldZ);
                class_2680 state = mc.field_1687.method_8320(pos);
                int color = mc.method_1505().method_1697(state, (class_1920)mc.field_1687, pos, 0);
                if (color == -1) {
                    color = -11184811;
                }
                int px = radius + dx;
                int pz = radius + dz;
                graphics.method_25294(px, pz, px + 1, pz + 1, 0xFF000000 | color);
            }
        }
        if (this.showEntities) {
            double radarRange = 32.0;
            for (class_1297 entity : mc.field_1687.method_18112()) {
                double dz;
                double dx;
                if (entity == player || (dx = entity.method_23317() - player.method_23317()) * dx + (dz = entity.method_23321() - player.method_23321()) * dz > radarRange * radarRange) continue;
                int ex = radius + (int)dx;
                int ez = radius + (int)dz;
                graphics.method_25294(ex - 1, ez - 1, ex + 1, ez + 1, -65536);
            }
        }
        graphics.method_25294(radius - 2, radius - 2, radius + 2, radius + 2, -16711936);
        graphics.method_51448().method_22909();
        if (editing) {
            graphics.method_25294(this.x, this.y, this.x + this.size, this.y + this.size, 0x66000000);
            graphics.method_49601(this.x, this.y, this.size, this.size, -7829368);
            graphics.method_51433(mc.field_1772, "[ MiniMap ]", this.x + 5, this.y - 10, -1, false);
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int width, int height) {
        this.size = Math.min(width, height);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setRgbMode(boolean enabled) {
    }

    @Override
    public boolean isRgbMode() {
        return false;
    }

    @Override
    public void setBackground(boolean background) {
        this.background = background;
    }

    @Override
    public boolean hasBackground() {
        return this.background;
    }

    @Override
    public String getName() {
        return "MiniMap";
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"feather_remake", (String)"textures/icons/minmap.png");
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.size) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.size);
    }

    @Override
    public boolean isResizing(double mouseX, double mouseY) {
        return Math.abs(mouseX - (double)(this.x + this.size)) < 6.0 && Math.abs(mouseY - (double)(this.y + this.size)) < 6.0;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.size;
    }

    @Override
    public int getHeight() {
        return this.size;
    }
}

