/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.joml.Vector3f;

public class BlockOutlineConfig {
    private static final File CONFIG_FILE = new File("config/feather_remake/feather_remake_outline.properties");
    public static boolean enabled = true;
    private static int outlineColor = -16711936;

    public static Vector3f getOutlineColor() {
        float r = (float)(outlineColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(outlineColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(outlineColor & 0xFF) / 255.0f;
        return new Vector3f(r, g, b);
    }

    public static int getOutlineColorRGB() {
        return outlineColor;
    }

    public static void setOutlineColor(int color) {
        outlineColor = color;
        BlockOutlineConfig.saveConfig();
    }

    public static void save() {
        BlockOutlineConfig.saveConfig();
    }

    private static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileInputStream input = new FileInputStream(CONFIG_FILE);){
                Properties prop = new Properties();
                prop.load(input);
                outlineColor = Integer.parseUnsignedInt(prop.getProperty("outlineColor"), 16);
                enabled = Boolean.parseBoolean(prop.getProperty("enabled", "true"));
            }
            catch (IOException | NumberFormatException e) {
                System.err.println("Failed to load outline color config, using defaults");
            }
        }
    }

    private static void saveConfig() {
        try (FileOutputStream output = new FileOutputStream(CONFIG_FILE);){
            Properties prop = new Properties();
            prop.setProperty("outlineColor", Integer.toHexString(outlineColor));
            prop.setProperty("enabled", Boolean.toString(enabled));
            prop.store(output, "Feather Remake Block Outline Config");
        }
        catch (IOException e) {
            System.err.println("Failed to save outline color config");
        }
    }

    static {
        BlockOutlineConfig.loadConfig();
    }
}

