/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class HitColorConfig {
    public static boolean enabled = true;
    public static int red = 255;
    public static int green = 0;
    public static int blue = 0;
    public static int alpha = 128;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/feather_remake/hitcolor.json");

    public static int getColor() {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static void setColor(int r, int g, int b) {
        red = r;
        green = g;
        blue = b;
    }

    public static void save() {
        try {
            if (!CONFIG_FILE.getParentFile().exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)new Data(enabled, red, green, blue, alpha), (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            Data data = (Data)GSON.fromJson((Reader)reader, Data.class);
            if (data != null) {
                enabled = data.enabled;
                red = data.red;
                green = data.green;
                blue = data.blue;
                alpha = data.alpha;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class Data {
        boolean enabled;
        int red;
        int green;
        int blue;
        int alpha;

        Data(boolean enabled, int red, int green, int blue, int alpha) {
            this.enabled = enabled;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }
    }
}

