/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.ashmeetop.feather_remake.client.settings.Config;

public class LogoConfig {
    private static final File CONFIG_FILE = new File("config/feather_remake/feather_remake.json");
    private static int selectedLogoIndex = 0;
    private static boolean loaded = false;

    public static int getLogoIndex() {
        LogoConfig.load();
        return selectedLogoIndex;
    }

    public static void setLogoIndex(int index, int max) {
        if (index >= 0 && index < max) {
            selectedLogoIndex = index;
            LogoConfig.save();
        }
    }

    private static void load() {
        if (loaded) {
            return;
        }
        try {
            if (CONFIG_FILE.exists()) {
                Gson gson = new Gson();
                FileReader reader = new FileReader(CONFIG_FILE);
                Config config = (Config)gson.fromJson((Reader)reader, Config.class);
                reader.close();
                if (config != null && config.logoIndex >= 0) {
                    selectedLogoIndex = config.logoIndex;
                }
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load Feather Remake config: " + e.getMessage());
        }
        loaded = true;
    }

    private static void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Config config = new Config();
            config.logoIndex = selectedLogoIndex;
            FileWriter writer = new FileWriter(CONFIG_FILE);
            gson.toJson((Object)config, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Failed to save Feather Remake config: " + e.getMessage());
        }
    }
}

