/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import org.ashmeetop.feather_remake.client.gui.element.HueShiftedImage;
import org.ashmeetop.feather_remake.client.gui.element.TexturedButton;

public class DynamicHueButton
extends TexturedButton {
    private float targetHueShift;
    private float currentHueShift;
    private final float hueTransitionSpeed;
    private final HueShiftedImage hueShiftedDefault;
    private final HueShiftedImage hueShiftedHover;

    public DynamicHueButton(int x, int y, int width, int height, int u, int v, class_2561 message, class_4185.class_4241 onPress, class_2960 defaultTexture, class_2960 hoverTexture, float initialHueShift, float hueTransitionSpeed) {
        super(x, y, width, height, u, v, message, onPress, defaultTexture, hoverTexture);
        this.currentHueShift = this.targetHueShift = (initialHueShift % 1.0f + 1.0f) % 1.0f;
        this.hueTransitionSpeed = hueTransitionSpeed;
        this.hueShiftedDefault = new HueShiftedImage(defaultTexture, this.currentHueShift);
        this.hueShiftedHover = new HueShiftedImage(hoverTexture, this.currentHueShift);
    }

    public void setTargetHueShift(float hueShift) {
        this.targetHueShift = (hueShift % 1.0f + 1.0f) % 1.0f;
    }

    public float getCurrentHueShift() {
        return this.currentHueShift;
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
        float hueDiff = this.targetHueShift - this.currentHueShift;
        if (Math.abs(hueDiff) > 0.001f) {
            float step = this.hueTransitionSpeed * delta;
            if (hueDiff > 0.5f) {
                hueDiff -= 1.0f;
            } else if (hueDiff < -0.5f) {
                hueDiff += 1.0f;
            }
            this.currentHueShift += hueDiff * step;
            this.currentHueShift = (this.currentHueShift % 1.0f + 1.0f) % 1.0f;
        }
        this.hueShiftedDefault.setHue(this.currentHueShift);
        this.hueShiftedHover.setHue(this.currentHueShift);
        boolean hovered = this.method_25367();
        float speed = 0.2f;
        this.hoverProgress = hovered ? Math.min(1.0f, this.hoverProgress + speed * delta) : Math.max(0.0f, this.hoverProgress - speed * delta);
        graphics.method_25291(class_1921::method_62275, this.hueShiftedDefault.getShiftedTexture(), this.method_46426(), this.method_46427(), (float)this.u, (float)this.v, this.field_22758, this.field_22759, this.texWidth, this.texHeight, -1);
        if (this.hoverProgress > 0.0f) {
            int slideWidth = (int)((float)this.field_22758 * this.hoverProgress);
            int alpha = (int)(this.hoverProgress * 255.0f) << 24;
            int color = 0xFFFFFF | alpha;
            graphics.method_25291(class_1921::method_62275, this.hueShiftedHover.getShiftedTexture(), this.method_46426(), this.method_46427(), (float)this.u, (float)this.v, slideWidth, this.field_22759, this.texWidth, this.texHeight, color);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void applyHueShift(float hueShift) {
    }
}

