/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.mixin;

import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_757;
import org.ashmeetop.feather_remake.client.settings.ZoomSettings;
import org.ashmeetop.feather_remake.client.util.ZoomMod;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_757.class})
public class ZoomMixin {
    @Shadow
    @Final
    private class_310 field_4015;
    private float zoomProgress = 0.0f;
    private float lastZoomProgress = 0.0f;

    @Inject(method={"getFov"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetFov(class_4184 camera, float tickDelta, boolean changingFov, CallbackInfoReturnable<Float> cir) {
        if (!ZoomSettings.enabled || this.field_4015.field_1690 == null || this.field_4015.field_1724 == null) {
            return;
        }
        boolean isZooming = ZoomMod.isZooming();
        float targetProgress = isZooming ? 1.0f : 0.0f;
        float progressDelta = (targetProgress - this.zoomProgress) * ZoomSettings.zoomSpeed * tickDelta * 20.0f;
        this.lastZoomProgress = this.zoomProgress;
        this.zoomProgress += progressDelta;
        this.zoomProgress = Math.max(0.0f, Math.min(1.0f, this.zoomProgress));
        if (this.zoomProgress > 0.0f || this.lastZoomProgress > 0.0f) {
            float smoothProgress = this.lastZoomProgress + (this.zoomProgress - this.lastZoomProgress) * tickDelta;
            float baseFov = ((Integer)this.field_4015.field_1690.method_41808().method_41753()).floatValue();
            float zoomFactor = 1.0f + (ZoomMod.getCurrentZoom() - 1.0f) * smoothProgress;
            float targetFov = baseFov / zoomFactor;
            cir.setReturnValue((Object)Float.valueOf(Math.max(10.0f, Math.min(200.0f, targetFov))));
        }
    }
}

