/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.minecraft.class_310;

public class CrosshairSettings {
    public static final int GRID_SIZE = 17;
    public static boolean[][] pixelMap = new boolean[17][17];
    public static int color = -1;
    public static boolean customCrosshairEnabled = true;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File FILE = new File(class_310.method_1551().field_1697, "config/feather_remake/crosshair.json");

    public static void save() {
        try (FileWriter writer = new FileWriter(FILE);){
            GSON.toJson((Object)new Data(pixelMap, color, customCrosshairEnabled), (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        if (!FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(FILE);){
            Data data = (Data)GSON.fromJson((Reader)reader, Data.class);
            if (data != null) {
                pixelMap = data.pixelMap;
                color = data.color;
                customCrosshairEnabled = data.enabled;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reset() {
        pixelMap = new boolean[17][17];
        color = -1;
        customCrosshairEnabled = true;
    }

    private static class Data {
        boolean[][] pixelMap;
        int color;
        boolean enabled;

        Data(boolean[][] pixelMap, int color, boolean enabled) {
            this.pixelMap = pixelMap;
            this.color = color;
            this.enabled = enabled;
        }
    }
}

