/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.class_310;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;
import org.ashmeetop.feather_remake.client.settings.FeatherHudManager;
import org.ashmeetop.feather_remake.client.settings.HudSettings;

public class FeatherSettings {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = class_310.method_1551().field_1697.toPath().resolve("config/feather_remake/hud_config.json");
    private static final Properties properties = new Properties();
    private static final Map<String, HudSettings> hudSettingsMap = new HashMap<String, HudSettings>();
    private static final Map<String, Boolean> booleanSettings = new HashMap<String, Boolean>();
    private static final String FULLBRIGHT_KEY = "fullbright_enabled";

    public boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(properties.getProperty(key, String.valueOf(defaultValue)));
    }

    public void setBoolean(String key, boolean value) {
        properties.setProperty(key, String.valueOf(value));
    }

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                Type type = new TypeToken<Map<String, Object>>(){}.getType();
                Map loaded = (Map)GSON.fromJson((Reader)reader, type);
                if (loaded != null) {
                    if (loaded.containsKey("hudSettings")) {
                        Type hudType = new TypeToken<Map<String, HudSettings>>(){}.getType();
                        Map hudSettings = (Map)GSON.fromJson(GSON.toJson(loaded.get("hudSettings")), hudType);
                        hudSettingsMap.putAll(hudSettings);
                    }
                    if (loaded.containsKey("booleanSettings")) {
                        Type boolType = new TypeToken<Map<String, Boolean>>(){}.getType();
                        Map boolSettings = (Map)GSON.fromJson(GSON.toJson(loaded.get("booleanSettings")), boolType);
                        booleanSettings.putAll(boolSettings);
                    }
                    FeatherSettings.applySettingsToElements();
                }
            }
            catch (IOException e) {
                System.err.println("[FeatherRemake] Failed to load config: " + e.getMessage());
            }
        }
    }

    public static void save() {
        FeatherSettings.syncFromElements();
        HashMap<String, Map<String, Object>> toSave = new HashMap<String, Map<String, Object>>();
        toSave.put("hudSettings", hudSettingsMap);
        toSave.put("booleanSettings", booleanSettings);
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson(toSave, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("[FeatherRemake] Failed to save config: " + e.getMessage());
        }
    }

    public static boolean isFullbrightEnabled() {
        return booleanSettings.getOrDefault(FULLBRIGHT_KEY, false);
    }

    public static void setFullbrightEnabled(boolean enabled) {
        booleanSettings.put(FULLBRIGHT_KEY, enabled);
        FeatherSettings.save();
    }

    private static void applySettingsToElements() {
        for (HudElement element : FeatherHudManager.getHuds()) {
            HudSettings settings = hudSettingsMap.get(element.getName());
            if (settings == null) continue;
            element.setPosition(settings.x, settings.y);
            element.setSize(settings.width, settings.height);
            element.setEnabled(settings.enabled);
        }
    }

    private static void syncFromElements() {
        for (HudElement element : FeatherHudManager.getHuds()) {
            hudSettingsMap.put(element.getName(), new HudSettings(element.getX(), element.getY(), element.getWidth(), element.getHeight(), element.isEnabled()));
        }
    }
}

