/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.settings;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public class ZoomSettings {
    private static final Path CONFIG_PATH = Path.of("config/feather_remake/zoom_settings.properties", new String[0]);
    public static float targetZoom = 5.0f;
    public static float zoomSpeed = 0.15f;
    public static float zoomStep = 0.05f;
    public static boolean smoothCamera = true;
    public static boolean enabled = true;

    public static void load() {
        Properties props = new Properties();
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(CONFIG_PATH, new OpenOption[0]);){
                props.load(in);
                targetZoom = Float.parseFloat(props.getProperty("targetZoom", "5.0"));
                zoomSpeed = Float.parseFloat(props.getProperty("zoomSpeed", "0.15"));
                zoomStep = Float.parseFloat(props.getProperty("zoomStep", "0.05"));
                smoothCamera = Boolean.parseBoolean(props.getProperty("smoothCamera", "true"));
                enabled = Boolean.parseBoolean(props.getProperty("enabled", "true"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        Properties props = new Properties();
        props.setProperty("targetZoom", String.valueOf(targetZoom));
        props.setProperty("zoomSpeed", String.valueOf(zoomSpeed));
        props.setProperty("zoomStep", String.valueOf(zoomStep));
        props.setProperty("smoothCamera", String.valueOf(smoothCamera));
        props.setProperty("enabled", String.valueOf(enabled));
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(CONFIG_PATH, new OpenOption[0]);){
                props.store(out, "Feather Remake Zoom Settings");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

