/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.util;

import java.awt.Color;
import java.util.Collection;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;

public class PotionHud
implements HudElement {
    private static final class_2960 ICON = class_2960.method_60655((String)"feather_remake", (String)"textures/icons/eff.png");
    private static final int MARGIN = 5;
    private static final int EFFECT_WIDTH = 120;
    private static final int EFFECT_HEIGHT = 20;
    private static final class_2960 RESIZE_HANDLE = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/remove.png");
    private boolean showDuration = true;
    private boolean showAmplifier = true;
    private boolean showEffectName = true;
    private int width = 120;
    private int height = 12;
    private int x = 0;
    private int y = 0;
    private boolean enabled = false;
    private int color = -1;
    private boolean background = true;
    private boolean rgbMode = false;

    @Override
    public void render(class_332 graphics, float tickDelta) {
        if (!this.isEnabled()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        Collection effects = mc.field_1724.method_6026();
        if (effects.isEmpty()) {
            return;
        }
        int currentX = this.getX();
        int currentY = this.getY();
        int i = 0;
        for (class_1293 effect : effects) {
            this.renderPotionEffect(graphics, effect, currentX, currentY + i * 20);
            ++i;
        }
        this.setSize(120, i * 20);
    }

    private void renderPotionEffect(class_332 graphics, class_1293 effect, int x, int y) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_1291 type = (class_1291)effect.method_5579().comp_349();
        int color = type.method_5556();
        class_2960 BOTTLE_OVERLAY = class_2960.method_60655((String)"minecraft", (String)"textures/item/potion_overlay.png");
        class_2960 BOTTLE_LIQUID = class_2960.method_60655((String)"minecraft", (String)"textures/item/potion.png");
        graphics.method_51448().method_22903();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        graphics.method_25290(class_1921::method_62275, BOTTLE_LIQUID, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        graphics.method_25290(class_1921::method_62275, BOTTLE_OVERLAY, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        int textX = x + 20;
        if (this.showEffectName) {
            Object name = type.method_5560().getString();
            if (this.showAmplifier && effect.method_5578() > 0) {
                name = (String)name + " " + PotionHud.toRoman(effect.method_5578() + 1);
            }
            graphics.method_25303(mc.field_1772, (String)name, textX, y + 3, this.color);
        }
        if (this.background) {
            int bgWidth = this.width;
            int bgHeight = this.height;
            graphics.method_25294(x, y, x + bgWidth, y + bgHeight, -2013265920);
        }
        int drawColor = this.color;
        if (this.rgbMode) {
            float hue = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
            drawColor = Color.HSBtoRGB(hue, 1.0f, 1.0f) | 0xFF000000;
        }
        if (this.showDuration && !effect.method_48559()) {
            float tickRate = mc.field_1687.method_54719().method_54748();
            String duration = String.valueOf(class_1292.method_5577((class_1293)effect, (float)1.0f, (float)tickRate));
            graphics.method_25303(mc.field_1772, duration, textX, y + 12, drawColor);
        }
        graphics.method_51448().method_22909();
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setBackground(boolean background) {
        this.background = background;
    }

    @Override
    public boolean hasBackground() {
        return this.background;
    }

    @Override
    public void render(class_332 graphics, boolean editing) {
        int drawColor = this.color;
        if (this.rgbMode) {
            float hue = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
            drawColor = Color.HSBtoRGB(hue, 1.0f, 1.0f) | 0xFF000000;
        }
        this.render(graphics, 0.0f);
        if (editing) {
            class_310 mc = class_310.method_1551();
            class_327 font = mc.field_1772;
            graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, 0x66000000);
            graphics.method_49601(this.x, this.y, this.width, this.height, -7829368);
            String label = "[ POTION HUD ]";
            int labelWidth = font.method_1727(label);
            graphics.method_25294(this.x + (this.width - labelWidth) / 2 - 3, this.y - 12, this.x + (this.width + labelWidth) / 2 + 3, this.y - 2, -2013265920);
            graphics.method_51433(font, label, this.x + this.width / 2 - labelWidth / 2, this.y - 10, -1, false);
            int handleSize = 8;
            graphics.method_25290(class_1921::method_62275, RESIZE_HANDLE, this.x + this.width - handleSize, this.y + this.height - handleSize, 0.0f, 0.0f, handleSize, handleSize, handleSize, handleSize);
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int width, int height) {
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.getWidth()) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.getHeight());
    }

    @Override
    public boolean isResizing(double mouseX, double mouseY) {
        return mouseX >= (double)(this.x + this.width - 5) && mouseX <= (double)(this.x + this.width + 1) && mouseY >= (double)(this.y + this.height - 5) && mouseY <= (double)(this.y + this.height + 1);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return 120;
    }

    @Override
    public int getHeight() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return 0;
        }
        return mc.field_1724.method_6026().size() * 20;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getName() {
        return "Potion Effects";
    }

    @Override
    public class_2960 getIcon() {
        return ICON;
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    @Override
    public void init() {
        class_310 mc = class_310.method_1551();
        this.setPosition(mc.method_22683().method_4486() - 120 - 5, 5);
        this.setEnabled(true);
    }

    private static String toRoman(int number) {
        return switch (number) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            default -> String.valueOf(number);
        };
    }

    public void setShowDuration(boolean showDuration) {
        this.showDuration = showDuration;
    }

    public void setShowAmplifier(boolean showAmplifier) {
        this.showAmplifier = showAmplifier;
    }

    @Override
    public void setRgbMode(boolean enabled) {
        this.rgbMode = enabled;
    }

    @Override
    public boolean isRgbMode() {
        return this.rgbMode;
    }

    public void setShowEffectName(boolean showEffectName) {
        this.showEffectName = showEffectName;
    }
}

