/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.waypoint;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.ashmeetop.feather_remake.client.waypoint.Waypoint;

public class WaypointManager {
    private static final List<Waypoint> waypoints = new ArrayList<Waypoint>();
    private static boolean enabled = true;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type LIST_TYPE = new TypeToken<List<Waypoint>>(){}.getType();
    private static final File dataDir = new File(System.getProperty("user.home"), ".feather_remake");
    private static final File waypointFile = new File(dataDir, "featherwaypoints.json");

    public static void removeWaypoint(Waypoint wp) {
        waypoints.remove(wp);
    }

    public static void addWaypoint(Waypoint waypoint) {
        waypoints.add(waypoint);
        WaypointManager.saveWaypoints();
    }

    public static List<Waypoint> getWaypoints() {
        return waypoints;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean value) {
        enabled = value;
        WaypointManager.saveWaypoints();
    }

    public static void saveWaypoints() {
        try (FileWriter writer = new FileWriter(waypointFile);){
            WaypointData data = new WaypointData();
            data.enabled = enabled;
            data.waypoints = waypoints;
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadWaypoints() {
        if (!waypointFile.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(waypointFile);){
            WaypointData data = (WaypointData)GSON.fromJson((Reader)reader, WaypointData.class);
            if (data != null) {
                waypoints.clear();
                waypoints.addAll(data.waypoints != null ? data.waypoints : new ArrayList());
                enabled = data.enabled;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        WaypointManager.loadWaypoints();
    }

    private static class WaypointData {
        boolean enabled = true;
        List<Waypoint> waypoints = new ArrayList<Waypoint>();

        private WaypointData() {
        }
    }
}

