/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.guifollowers_common_neoforge.events;

import com.mojang.blaze3d.platform.Window;
import com.natamus.collective_common_neoforge.functions.GUIFunctions;
import com.natamus.collective_common_neoforge.functions.WorldFunctions;
import com.natamus.guifollowers_common_neoforge.config.ConfigHandler;
import com.natamus.guifollowers_common_neoforge.data.Variables;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3x2fStack;

public class GUIEvent {
    private static final Minecraft mc = Minecraft.getInstance();

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (GUIFunctions.shouldHideGUI()) {
            return;
        }
        Font font = GUIEvent.mc.font;
        Window scaled = mc.getWindow();
        Matrix3x2fStack matrixStack = guiGraphics.pose();
        matrixStack.pushMatrix();
        if (Variables.activefollowers.size() > 0) {
            int width = scaled.getGuiScaledWidth();
            String displaystring = ConfigHandler.followerListHeaderFormat;
            int stringWidth = font.width(displaystring);
            Color colour = new Color(ConfigHandler.RGB_R, ConfigHandler.RGB_G, ConfigHandler.RGB_B, 255);
            int xoffset = 5;
            int xcoord = ConfigHandler.followerListPositionIsLeft ? 5 : (ConfigHandler.followerListPositionIsCenter ? width / 2 - stringWidth / 2 : width - stringWidth - 5);
            boolean drawnfirst = false;
            int heightoffset = ConfigHandler.followerListHeightOffset;
            LocalPlayer player = GUIEvent.mc.player;
            String playerdimension = WorldFunctions.getWorldDimensionName((Level)player.level());
            ArrayList<Entity> toremove = new ArrayList<Entity>();
            for (Entity follower : new ArrayList<Entity>(Variables.activefollowers)) {
                String followerdimension = WorldFunctions.getWorldDimensionName((Level)follower.level());
                if (!playerdimension.equals(followerdimension)) {
                    toremove.add(follower);
                    continue;
                }
                if (!follower.isAlive() || !(follower instanceof TamableAnimal)) {
                    toremove.add(follower);
                    continue;
                }
                TamableAnimal te = (TamableAnimal)follower;
                if (te.isInSittingPose()) {
                    toremove.add(follower);
                    continue;
                }
                Object follower_string = follower.getName().getString();
                if (ConfigHandler.showFollowerHealth) {
                    LivingEntity le = (LivingEntity)follower;
                    float currenthealth = le.getHealth();
                    float maxhealth = le.getMaxHealth();
                    int percenthealth = (int)(100.0f / maxhealth * currenthealth);
                    if (percenthealth <= 0) {
                        toremove.add(follower);
                        continue;
                    }
                    String healthformat = ConfigHandler.followerHealthFormat;
                    follower_string = (String)follower_string + healthformat.replaceAll("<health>", "" + percenthealth);
                }
                if (ConfigHandler.showFollowerDistance) {
                    Vec3 pvec = player.position();
                    Vec3 fvec = follower.position();
                    double distance = pvec.distanceTo(fvec);
                    String distanceformat = ConfigHandler.followerDistanceFormat;
                    follower_string = (String)follower_string + distanceformat.replaceAll("<distance>", String.format("%.2f", distance));
                }
                int follower_stringWidth = font.width((String)follower_string);
                if (ConfigHandler.followerListPositionIsCenter) {
                    xcoord = width / 2 - follower_stringWidth / 2 - xoffset;
                } else if (!ConfigHandler.followerListPositionIsLeft) {
                    xcoord = width - follower_stringWidth - 5 - xoffset;
                }
                if (!drawnfirst) {
                    GUIEvent.drawText(font, guiGraphics, displaystring, xcoord, heightoffset, colour.getRGB(), ConfigHandler.drawTextShadow);
                    drawnfirst = true;
                }
                GUIEvent.drawText(font, guiGraphics, (String)follower_string, xcoord + xoffset, heightoffset += 10, colour.getRGB(), ConfigHandler.drawTextShadow);
            }
            if (toremove.size() > 0) {
                for (Entity etr : toremove) {
                    Variables.activefollowers.remove(etr);
                }
            }
        }
        matrixStack.popMatrix();
    }

    private static void drawText(Font font, GuiGraphics guiGraphics, String content, int x, int y, int rgb, boolean drawShadow) {
        guiGraphics.drawString(font, (Component)Component.literal((String)content), x, y, rgb, drawShadow);
    }
}

