/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.guifollowers_common_forge.events;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.natamus.collective_common_forge.functions.GUIFunctions;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.guifollowers_common_forge.config.ConfigHandler;
import com.natamus.guifollowers_common_forge.data.Variables;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GUIEvent {
    private static final Minecraft mc = Minecraft.m_91087_();

    public static void renderOverlay(GuiGraphics guiGraphics, float tickDelta) {
        if (GUIFunctions.shouldHideGUI()) {
            return;
        }
        Font font = GUIEvent.mc.f_91062_;
        Window scaled = mc.m_91268_();
        PoseStack posestack = guiGraphics.m_280168_();
        posestack.m_85836_();
        if (Variables.activefollowers.size() > 0) {
            int width = scaled.m_85445_();
            String displaystring = ConfigHandler.followerListHeaderFormat;
            int stringWidth = font.m_92895_(displaystring);
            Color colour = new Color(ConfigHandler.RGB_R, ConfigHandler.RGB_G, ConfigHandler.RGB_B, 255);
            int xoffset = 5;
            int xcoord = ConfigHandler.followerListPositionIsLeft ? 5 : (ConfigHandler.followerListPositionIsCenter ? width / 2 - stringWidth / 2 : width - stringWidth - 5);
            boolean drawnfirst = false;
            int heightoffset = ConfigHandler.followerListHeightOffset;
            LocalPlayer player = GUIEvent.mc.f_91074_;
            String playerdimension = WorldFunctions.getWorldDimensionName((Level)player.m_9236_());
            ArrayList<Entity> toremove = new ArrayList<Entity>();
            for (Entity follower : new ArrayList<Entity>(Variables.activefollowers)) {
                String followerdimension = WorldFunctions.getWorldDimensionName((Level)follower.m_9236_());
                if (!playerdimension.equals(followerdimension)) {
                    toremove.add(follower);
                    continue;
                }
                if (!follower.m_6084_() || !(follower instanceof TamableAnimal)) {
                    toremove.add(follower);
                    continue;
                }
                TamableAnimal te = (TamableAnimal)follower;
                if (te.m_21825_()) {
                    toremove.add(follower);
                    continue;
                }
                Object follower_string = follower.m_7755_().getString();
                if (ConfigHandler.showFollowerHealth) {
                    LivingEntity le = (LivingEntity)follower;
                    float currenthealth = le.m_21223_();
                    float maxhealth = le.m_21233_();
                    int percenthealth = (int)(100.0f / maxhealth * currenthealth);
                    if (percenthealth <= 0) {
                        toremove.add(follower);
                        continue;
                    }
                    String healthformat = ConfigHandler.followerHealthFormat;
                    follower_string = (String)follower_string + healthformat.replaceAll("<health>", "" + percenthealth);
                }
                if (ConfigHandler.showFollowerDistance) {
                    Vec3 pvec = player.m_20182_();
                    Vec3 fvec = follower.m_20182_();
                    double distance = pvec.m_82554_(fvec);
                    String distanceformat = ConfigHandler.followerDistanceFormat;
                    follower_string = (String)follower_string + distanceformat.replaceAll("<distance>", String.format("%.2f", distance));
                }
                int follower_stringWidth = font.m_92895_((String)follower_string);
                if (ConfigHandler.followerListPositionIsCenter) {
                    xcoord = width / 2 - follower_stringWidth / 2 - xoffset;
                } else if (!ConfigHandler.followerListPositionIsLeft) {
                    xcoord = width - follower_stringWidth - 5 - xoffset;
                }
                if (!drawnfirst) {
                    GUIEvent.drawText(font, guiGraphics, displaystring, xcoord, heightoffset, colour.getRGB(), ConfigHandler.drawTextShadow);
                    drawnfirst = true;
                }
                GUIEvent.drawText(font, guiGraphics, (String)follower_string, xcoord + xoffset, heightoffset += 10, colour.getRGB(), ConfigHandler.drawTextShadow);
            }
            if (toremove.size() > 0) {
                for (Entity etr : toremove) {
                    Variables.activefollowers.remove(etr);
                }
            }
        }
        posestack.m_85849_();
    }

    private static void drawText(Font font, GuiGraphics guiGraphics, String content, int x, int y, int rgb, boolean drawShadow) {
        guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)content), x, y, rgb, drawShadow);
    }
}

