/*
 * Decompiled with CFR 0.152.
 */
package com.boehmod.blockfront;

import com.boehmod.blockfront.id;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class hy {
    private static final String ab = "https://sessionserver.mojang.com/session/minecraft/profile/%s";
    @NotNull
    private final ExecutorService a;
    @NotNull
    private final Cache<UUID, CompletableFuture<ResourceLocation>> a = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).removalListener(removalNotification -> {
        CompletableFuture completableFuture = (CompletableFuture)removalNotification.getValue();
        if (completableFuture != null && completableFuture.isDone()) {
            try {
                Minecraft.getInstance().getTextureManager().release((ResourceLocation)completableFuture.get());
                id.log("Released texture for: " + String.valueOf(removalNotification.getKey()), new Object[0]);
            }
            catch (Exception exception) {
                id.log("Failed to release texture for: " + String.valueOf(removalNotification.getKey()) + " due to: " + exception.getMessage(), new Object[0]);
            }
        }
    }).build();

    @NotNull
    public ResourceLocation a(@NotNull Minecraft minecraft, @NotNull UUID uUID) {
        try {
            CompletableFuture completableFuture = (CompletableFuture)this.a.get(uUID, () -> CompletableFuture.supplyAsync(() -> this.b(minecraft, uUID), this.a));
            return completableFuture.getNow(DefaultPlayerSkin.get((UUID)uUID).texture());
        }
        catch (Exception exception) {
            id.a("Failed to fetch skin for player '" + String.valueOf(uUID) + "' due to: ", exception, new Object[0]);
            return DefaultPlayerSkin.get((UUID)uUID).texture();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ResourceLocation b(@NotNull Minecraft minecraft, @NotNull UUID uUID) {
        id.log("Fetching skin for player '%s'...", uUID);
        try {
            String string = String.format(ab, uUID.toString().replace("-", ""));
            URL uRL = URI.create(string).toURL();
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setDoInput(true);
            httpURLConnection.connect();
            try {
                ResourceLocation resourceLocation;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                    String string2;
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string2);
                    }
                    String string3 = ((JsonObject)new Gson().fromJson(stringBuilder.toString(), JsonObject.class)).getAsJsonArray("properties").get(0).getAsJsonObject().get("value").getAsString();
                    String string4 = new String(Base64.getDecoder().decode(string3));
                    String string5 = ((JsonObject)new Gson().fromJson(string4, JsonObject.class)).getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
                    BufferedImage bufferedImage = ImageIO.read(URI.create(string5).toURL());
                    NativeImage nativeImage = new NativeImage(bufferedImage.getWidth(), bufferedImage.getHeight(), true);
                    for (int i2 = 0; i2 < bufferedImage.getWidth(); ++i2) {
                        for (int i3 = 0; i3 < bufferedImage.getHeight(); ++i3) {
                            int n2 = bufferedImage.getRGB(i2, i3);
                            int n3 = n2 >> 24 & 0xFF;
                            int n4 = n2 >> 16 & 0xFF;
                            int n5 = n2 >> 8 & 0xFF;
                            int n6 = n2 & 0xFF;
                            int n7 = n3 << 24 | n6 << 16 | n5 << 8 | n4;
                            nativeImage.setPixelRGBA(i2, i3, n7);
                        }
                    }
                    CompletableFuture completableFuture = new CompletableFuture();
                    minecraft.submit(() -> {
                        try {
                            ResourceLocation resourceLocation = Minecraft.getInstance().getTextureManager().register("skins/" + String.valueOf(uUID), new DynamicTexture(nativeImage));
                            completableFuture.complete(resourceLocation);
                            id.log("Successfully fetched and registered skin for player '" + String.valueOf(uUID) + "'!", new Object[0]);
                        }
                        catch (Exception exception) {
                            completableFuture.completeExceptionally(exception);
                        }
                    });
                    resourceLocation = (ResourceLocation)completableFuture.get();
                }
                return resourceLocation;
            }
            finally {
                httpURLConnection.disconnect();
            }
        }
        catch (Exception exception) {
            id.logError("Failed to fetch or register skin for player '" + String.valueOf(uUID) + "'. Retrying.", new Object[0]);
            return DefaultPlayerSkin.get((UUID)uUID).texture();
        }
    }

    public void shutdown() {
        this.a.shutdown();
    }
}

