#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;
uniform sampler2D Sampler3;
uniform sampler2D Sampler4;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;
uniform float BloodFac;
uniform float MudFac;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
    vec4 bloodColor = texture(Sampler3, texCoord0 * textureSize(Sampler0, 0) / textureSize(Sampler3, 0));
    vec4 mudColor = texture(Sampler4, texCoord0 * textureSize(Sampler0, 0) / textureSize(Sampler4, 0));

    if (color.a < 0.1) {
        discard;
    }

    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);
    color.rgb = mix(color.rgb, bloodColor.rgb, bloodColor.a * 0.5 * BloodFac);
    color.rgb = mix(color.rgb, mudColor.rgb, mudColor.a * 0.5 * MudFac);

    color *= lightMapColor;
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}