/*
 * Decompiled with CFR 0.152.
 */
package flanox.fr.mineGPT;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import flanox.fr.mineGPT.MineGPT;
import java.io.IOException;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class MineGPTCommand
implements CommandExecutor {
    private final String apiKey;
    private final OkHttpClient client;

    public MineGPTCommand(MineGPT plugin, String apiKey) {
        this.apiKey = apiKey;
        this.client = new OkHttpClient();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (args2.length == 0) {
            sender.sendMessage("\u00a7cUsage: /minegpt <question>");
            return false;
        }
        String prompt = String.join((CharSequence)" ", args2);
        sender.sendMessage("\u00a77[MineGPT] Envoi de la requ\u00eate...");
        this.sendOpenAiRequest(prompt, response -> sender.sendMessage("\u00a7a[MineGPT] R\u00e9ponse: \u00a7f" + response), error -> sender.sendMessage("\u00a7c[MineGPT] Erreur: " + error));
        return true;
    }

    private void sendOpenAiRequest(String prompt, final Consumer<String> onSuccess, final Consumer<String> onError) {
        JsonObject messageObj = new JsonObject();
        messageObj.addProperty("role", "user");
        messageObj.addProperty("content", prompt);
        JsonArray messages = new JsonArray();
        messages.add(messageObj);
        JsonObject json = new JsonObject();
        json.addProperty("model", "gpt-3.5-turbo");
        json.add("messages", messages);
        RequestBody body = RequestBody.create(json.toString(), MediaType.get("application/json"));
        Request request = new Request.Builder().url("https://api.openai.com/v1/chat/completions").header("Authorization", "Bearer " + this.apiKey).post(body).build();
        this.client.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                onError.accept(e.getMessage());
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful()) {
                    onError.accept("HTTP " + response.code());
                    return;
                }
                String body = response.body().string();
                JsonObject jsonResponse = JsonParser.parseString(body).getAsJsonObject();
                String answer = jsonResponse.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
                onSuccess.accept(answer);
            }
        });
    }
}

