/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BannerPatternRegistry;
import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.item.BottledButterflyItem;
import com.bokmcdok.butterflies.world.item.BottledCaterpillarItem;
import com.bokmcdok.butterflies.world.item.ButterflyBookItem;
import com.bokmcdok.butterflies.world.item.ButterflyEggItem;
import com.bokmcdok.butterflies.world.item.ButterflyNetItem;
import com.bokmcdok.butterflies.world.item.ButterflyScrollItem;
import com.bokmcdok.butterflies.world.item.ButterflyTab;
import com.bokmcdok.butterflies.world.item.ButterflyZhuangziItem;
import com.bokmcdok.butterflies.world.item.CaterpillarItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ItemRegistry {
    private final DeferredRegister<Item> deferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"butterflies");
    private BlockRegistry blockRegistry;
    private EntityTypeRegistry entityTypeRegistry;
    private RegistryObject<Item> emptyButterflyNet;
    private List<RegistryObject<Item>> butterflyNets;
    private RegistryObject<Item> burntButterflyNet;
    private List<RegistryObject<Item>> butterflyEggs;
    private List<RegistryObject<Item>> caterpillars;
    private List<RegistryObject<Item>> bottledButterflies;
    private List<RegistryObject<Item>> bottledCaterpillars;
    private List<RegistryObject<Item>> butterflyScrolls;
    private RegistryObject<Item> butterflyBook;
    private RegistryObject<Item> zhuangziBook;
    private RegistryObject<Item> butterflyFeeder;
    private RegistryObject<Item> butterflyMicroscope;
    private RegistryObject<Item> infestedApple;
    private RegistryObject<Item> silk;
    private List<RegistryObject<Item>> butterflyOrigami;
    private RegistryObject<Item> butterflyPotterySherd;
    private RegistryObject<Item> butterflyBannerPattern;
    private List<RegistryObject<Item>> eggSpawnEggs;
    private List<RegistryObject<Item>> chrysalisSpawnEggs;
    private List<RegistryObject<Item>> caterpillarSpawnEggs;
    private List<RegistryObject<Item>> butterflySpawnEggs;
    private RegistryObject<Item> butterflyGolemSpawnEgg;

    public ItemRegistry(@NotNull IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(@NotNull BannerPatternRegistry bannerPatternRegistry, @NotNull BlockRegistry blockRegistry, @NotNull EntityTypeRegistry entityTypeRegistry) {
        int i;
        int i2;
        Objects.requireNonNull(bannerPatternRegistry, "bannerPatternRegistry cannot be null");
        this.blockRegistry = Objects.requireNonNull(blockRegistry, "blockRegistry cannot be null");
        this.entityTypeRegistry = Objects.requireNonNull(entityTypeRegistry, "entityTypeRegistry cannot be null");
        ButterflyTab butterflyTab = new ButterflyTab(CreativeModeTab.f_40748_.length, "butterfly_tab", this);
        Item.Properties baseProperties = new Item.Properties().m_41491_((CreativeModeTab)butterflyTab);
        Item.Properties stacksToOne = baseProperties.m_41487_(1);
        this.emptyButterflyNet = this.deferredRegister.register("butterfly_net", () -> new ButterflyNetItem(stacksToOne, this, -1));
        this.butterflyNets = new ArrayList<RegistryObject<Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.butterflyNets.add(this.registerButterflyNet(stacksToOne, i2));
        }
        this.burntButterflyNet = this.deferredRegister.register("butterfly_net_burnt", () -> new Item(stacksToOne));
        this.butterflyEggs = new ArrayList<RegistryObject<Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.butterflyEggs.add(this.registerButterflyEgg(i2, baseProperties));
        }
        this.caterpillars = new ArrayList<RegistryObject<Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.caterpillars.add(this.registerCaterpillar(baseProperties, i2));
        }
        this.bottledButterflies = new ArrayList<RegistryObject<Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.bottledButterflies.add(this.registerBottledButterfly(stacksToOne, i2));
        }
        this.bottledCaterpillars = new ArrayList<RegistryObject<Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.bottledCaterpillars.add(this.registerBottledCaterpillar(stacksToOne, i2));
        }
        this.butterflyScrolls = new ArrayList<RegistryObject<Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.butterflyScrolls.add(this.registerButterflyScroll(baseProperties, i2));
        }
        this.butterflyBook = this.deferredRegister.register("butterfly_book", () -> new ButterflyBookItem(stacksToOne));
        this.zhuangziBook = this.deferredRegister.register("butterfly_zhuangzi", () -> new ButterflyZhuangziItem(stacksToOne));
        this.butterflyFeeder = this.deferredRegister.register("butterfly_feeder", () -> new BlockItem((Block)blockRegistry.getButterflyFeeder().get(), baseProperties));
        this.butterflyMicroscope = this.deferredRegister.register("butterfly_microscope", () -> new BlockItem((Block)blockRegistry.getButterflyMicroscope().get(), baseProperties));
        this.infestedApple = this.deferredRegister.register("infested_apple", () -> new Item(baseProperties));
        this.silk = this.deferredRegister.register("silk", () -> new Item(baseProperties));
        this.butterflyOrigami = new ArrayList<RegistryObject<Item>>();
        for (RegistryObject<Block> block : blockRegistry.getButterflyOrigami()) {
            this.butterflyOrigami.add((RegistryObject<Item>)this.deferredRegister.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), baseProperties)));
        }
        this.butterflyPotterySherd = this.deferredRegister.register("butterfly_pottery_sherd", () -> new Item(baseProperties));
        this.butterflyBannerPattern = this.deferredRegister.register("banner_pattern_butterfly", () -> new BannerPatternItem(bannerPatternRegistry.getButterflyBannerPatternTagKey(), stacksToOne.m_41497_(Rarity.UNCOMMON)));
        this.eggSpawnEggs = new ArrayList<RegistryObject<Item>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            this.eggSpawnEggs.add(this.registerButterflyEggSpawnEgg(baseProperties, i));
        }
        this.chrysalisSpawnEggs = new ArrayList<RegistryObject<Item>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            this.chrysalisSpawnEggs.add(this.registerChrysalisSpawnEgg(baseProperties, i));
        }
        this.caterpillarSpawnEggs = new ArrayList<RegistryObject<Item>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            this.caterpillarSpawnEggs.add(this.registerCaterpillarSpawnEgg(baseProperties, i));
        }
        this.butterflySpawnEggs = new ArrayList<RegistryObject<Item>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            this.butterflySpawnEggs.add(this.registerButterflySpawnEgg(baseProperties, i));
        }
        this.butterflyGolemSpawnEgg = this.deferredRegister.register("spawn_egg_golem_butterfly", () -> new ForgeSpawnEggItem(entityTypeRegistry.getButterflyGolem(), 0xFFFFFF, 0xFFFFFF, baseProperties));
    }

    public List<RegistryObject<Item>> getBottledButterflies() {
        return this.bottledButterflies;
    }

    public List<RegistryObject<Item>> getBottledCaterpillars() {
        return this.bottledCaterpillars;
    }

    public RegistryObject<Item> getButterflyBannerPattern() {
        return this.butterflyBannerPattern;
    }

    public RegistryObject<Item> getButterflyBook() {
        return this.butterflyBook;
    }

    public RegistryObject<Item> getButterflyMicroscope() {
        return this.butterflyMicroscope;
    }

    public RegistryObject<Item> getBurntButterflyNet() {
        return this.burntButterflyNet;
    }

    public List<RegistryObject<Item>> getButterflyEggs() {
        return this.butterflyEggs;
    }

    public RegistryObject<Item> getButterflyNetFromIndex(int butterflyIndex) {
        if (butterflyIndex < 0) {
            return this.emptyButterflyNet;
        }
        if (Objects.equals(ButterflyInfo.SPECIES[butterflyIndex], "lava")) {
            return this.burntButterflyNet;
        }
        return this.butterflyNets.get(butterflyIndex);
    }

    public RegistryObject<Item> getButterflyFeeder() {
        return this.butterflyFeeder;
    }

    public List<RegistryObject<Item>> getButterflyNets() {
        return this.butterflyNets;
    }

    public List<RegistryObject<Item>> getButterflyOrigami() {
        return this.butterflyOrigami;
    }

    public RegistryObject<Item> getButterflyPotterySherd() {
        return this.butterflyPotterySherd;
    }

    public List<RegistryObject<Item>> getButterflyScrolls() {
        return this.butterflyScrolls;
    }

    public List<RegistryObject<Item>> getButterflySpawnEggs() {
        return this.butterflySpawnEggs;
    }

    public RegistryObject<Item> getButterflyGolemSpawnEgg() {
        return this.butterflyGolemSpawnEgg;
    }

    public List<RegistryObject<Item>> getCaterpillars() {
        return this.caterpillars;
    }

    public List<RegistryObject<Item>> getEggSpawnEggs() {
        return this.eggSpawnEggs;
    }

    public List<RegistryObject<Item>> getChrysalisSpawnEggs() {
        return this.chrysalisSpawnEggs;
    }

    public List<RegistryObject<Item>> getCaterpillarSpawnEggs() {
        return this.caterpillarSpawnEggs;
    }

    public RegistryObject<Item> getEmptyButterflyNet() {
        return this.emptyButterflyNet;
    }

    public RegistryObject<Item> getInfestedApple() {
        return this.infestedApple;
    }

    public RegistryObject<Item> getSilk() {
        return this.silk;
    }

    public RegistryObject<Item> getZhuangziBook() {
        return this.zhuangziBook;
    }

    private RegistryObject<Item> registerButterflyNet(Item.Properties properties, int butterflyIndex) {
        return this.deferredRegister.register(ButterflyNetItem.getRegistryId(butterflyIndex), () -> new ButterflyNetItem(properties, this, butterflyIndex));
    }

    private RegistryObject<Item> registerBottledButterfly(Item.Properties properties, int butterflyIndex) {
        return this.deferredRegister.register(BottledButterflyItem.getRegistryId(butterflyIndex), () -> new BottledButterflyItem(properties, this.blockRegistry.getBottledButterflyBlocks().get(butterflyIndex), butterflyIndex));
    }

    private RegistryObject<Item> registerBottledCaterpillar(Item.Properties properties, int butterflyIndex) {
        return this.deferredRegister.register(BottledCaterpillarItem.getRegistryId(butterflyIndex), () -> new BottledCaterpillarItem(properties, this.blockRegistry.getBottledCaterpillarBlocks().get(butterflyIndex), butterflyIndex));
    }

    private RegistryObject<Item> registerButterflyEgg(int butterflyIndex, Item.Properties properties) {
        return this.deferredRegister.register(ButterflyEggItem.getRegistryId(butterflyIndex), () -> new ButterflyEggItem(butterflyIndex, properties));
    }

    private RegistryObject<Item> registerButterflyScroll(Item.Properties properties, int butterflyIndex) {
        return this.deferredRegister.register(ButterflyScrollItem.getRegistryId(butterflyIndex), () -> new ButterflyScrollItem(properties, this.entityTypeRegistry, butterflyIndex));
    }

    private RegistryObject<Item> registerCaterpillar(Item.Properties properties, int butterflyIndex) {
        return this.deferredRegister.register(CaterpillarItem.getRegistryId(butterflyIndex), () -> new CaterpillarItem(properties, Caterpillar.getRegistryId(butterflyIndex)));
    }

    private RegistryObject<Item> registerButterflyEggSpawnEgg(Item.Properties properties, int butterflyIndex) {
        return this.deferredRegister.register("spawn_egg_egg_" + Butterfly.getRegistryId(butterflyIndex), () -> new ForgeSpawnEggItem((Supplier)this.entityTypeRegistry.getButterflyEggs().get(butterflyIndex), 0xFFFFFF, 0xFFFFFF, properties));
    }

    private RegistryObject<Item> registerCaterpillarSpawnEgg(Item.Properties properties, int butterflyIndex) {
        return this.deferredRegister.register("spawn_egg_" + CaterpillarItem.getRegistryId(butterflyIndex), () -> new ForgeSpawnEggItem((Supplier)this.entityTypeRegistry.getCaterpillars().get(butterflyIndex), 0xFFFFFF, 0xFFFFFF, properties));
    }

    private RegistryObject<Item> registerChrysalisSpawnEgg(Item.Properties properties, int butterflyIndex) {
        return this.deferredRegister.register("spawn_egg_chrysalis_" + Butterfly.getRegistryId(butterflyIndex), () -> new ForgeSpawnEggItem((Supplier)this.entityTypeRegistry.getChrysalises().get(butterflyIndex), 0xFFFFFF, 0xFFFFFF, properties));
    }

    private RegistryObject<Item> registerButterflySpawnEgg(Item.Properties properties, int butterflyIndex) {
        return this.deferredRegister.register("spawn_egg_butterfly_" + Butterfly.getRegistryId(butterflyIndex), () -> new ForgeSpawnEggItem((Supplier)this.entityTypeRegistry.getButterflies().get(butterflyIndex), 0xFFFFFF, 0xFFFFFF, properties));
    }
}

