/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.ai;

import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;

public abstract class ButterflyLandOnBlockGoal
extends MoveToBlockGoal {
    protected final Butterfly butterfly;

    public ButterflyLandOnBlockGoal(Butterfly mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super((PathfinderMob)mob, speedModifier, searchRange, verticalSearchRange);
        this.butterfly = mob;
    }

    public boolean m_8045_() {
        return this.m_6465_((LevelReader)this.f_25598_.m_9236_(), this.f_25602_);
    }

    public void m_8041_() {
        this.butterfly.setNotLanded();
        super.m_8041_();
    }

    public void m_8037_() {
        if (this.m_25625_()) {
            --this.f_25601_;
            this.f_25598_.m_21573_().m_26573_();
            this.butterfly.setLanded(this.f_25602_);
        } else {
            ++this.f_25601_;
            this.butterfly.setNotLanded();
            if (this.m_8064_()) {
                this.m_25624_();
            }
        }
    }

    @NotNull
    public String toString() {
        return "Land On Block / Target = [" + String.valueOf(this.m_6669_()) + "] / Position = [" + String.valueOf(this.butterfly.m_20183_()) + "] / Reached = [" + this.m_25625_() + "] / Landed = [" + this.butterfly.getIsLanded() + "] / Direction = [" + String.valueOf(this.butterfly.getLandedDirection()) + "]";
    }

    protected boolean m_25625_() {
        BlockPos position;
        Level level = this.butterfly.m_9236_();
        if (level.m_46859_(position = this.butterfly.m_20183_())) {
            if (this.m_6465_((LevelReader)level, position.m_7495_())) {
                this.f_25602_ = position.m_7495_();
                this.butterfly.setLandedDirection(Direction.DOWN);
                return true;
            }
            if (this.m_6465_((LevelReader)level, position.m_7494_())) {
                this.f_25602_ = position.m_7494_();
                this.butterfly.setLandedDirection(Direction.UP);
                return true;
            }
            if (this.m_6465_((LevelReader)level, position.m_122012_())) {
                this.f_25602_ = position.m_122012_();
                this.butterfly.setLandedDirection(Direction.NORTH);
                return true;
            }
            if (this.m_6465_((LevelReader)level, position.m_122019_())) {
                this.f_25602_ = position.m_122019_();
                this.butterfly.setLandedDirection(Direction.SOUTH);
                return true;
            }
            if (this.m_6465_((LevelReader)level, position.m_122029_())) {
                this.f_25602_ = position.m_122029_();
                this.butterfly.setLandedDirection(Direction.EAST);
                return true;
            }
            if (this.m_6465_((LevelReader)level, position.m_122024_())) {
                this.f_25602_ = position.m_122024_();
                this.butterfly.setLandedDirection(Direction.WEST);
                return true;
            }
        }
        return false;
    }

    protected boolean m_6465_(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos) {
        if (this.butterfly.isValidLandingBlock(levelReader.m_8055_(blockPos))) {
            for (Direction d : Direction.values()) {
                if (!levelReader.m_46859_(blockPos.m_121945_(d))) continue;
                return true;
            }
        }
        return false;
    }

    protected void m_25624_() {
        this.f_25598_.m_21573_().m_26519_((double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_() + 0.5, this.f_25599_);
    }
}

