/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.ai;

import com.bokmcdok.butterflies.config.ButterfliesConfig;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.entity.ai.ButterflyLandOnBlockGoal;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import org.jetbrains.annotations.NotNull;

public class ButterflyLayEggGoal
extends ButterflyLandOnBlockGoal {
    public ButterflyLayEggGoal(Butterfly mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super(mob, speedModifier, searchRange, verticalSearchRange);
    }

    @Override
    public boolean m_8045_() {
        return this.butterfly.getIsActive() && super.m_8045_();
    }

    public boolean m_8036_() {
        return this.butterfly.getIsActive() && this.butterfly.getIsFertile() && super.m_8036_();
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (this.butterfly.getIsLanded()) {
            this.f_25601_ -= 11;
            if (this.butterfly.getIsFertile()) {
                List numButterflies = this.butterfly.f_19853_.m_45971_(Butterfly.class, TargetingConditions.m_148353_(), (LivingEntity)this.butterfly, this.butterfly.m_20191_().m_82400_(32.0));
                int maxDensity = (Integer)ButterfliesConfig.Common.maxDensity.get();
                if (maxDensity == 0 || numButterflies.size() <= maxDensity) {
                    ButterflyData data;
                    Direction direction = this.butterfly.getLandedDirection().m_122424_();
                    if (this.butterfly.m_9236_().m_8055_(this.f_25602_.m_121945_(direction)).m_60795_() && (data = ButterflyData.getEntry(this.butterfly.getData().getBaseButterflyIndex())) != null) {
                        ResourceLocation eggEntity = data.getButterflyEggEntity();
                        ButterflyEgg.spawn((ServerLevel)this.butterfly.m_9236_(), eggEntity, this.f_25602_, direction);
                        this.butterfly.setIsFertile(false);
                        this.butterfly.useEgg();
                    }
                }
            }
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "Lay Egg / Target = [" + String.valueOf(this.m_6669_()) + "] / Position = [" + String.valueOf(this.butterfly.m_20183_()) + "] / Reached = [" + this.m_25625_() + "] / Landed = [" + this.butterfly.getIsLanded() + "] / Direction = [" + String.valueOf(this.butterfly.getLandedDirection()) + "] / Fertile = [" + this.butterfly.getIsFertile() + "] / Num Eggs = [" + this.butterfly.getNumEggs() + "]";
    }
}

