/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.item.ButterflyContainerItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BottledButterflyItem
extends BlockItem
implements ButterflyContainerItem {
    private static final String NAME = "block.butterflies.bottled_butterfly";
    private final int butterflyIndex;

    public static String getRegistryId(int butterflyIndex) {
        return "bottled_butterfly_" + ButterflySpeciesList.SPECIES[butterflyIndex];
    }

    public BottledButterflyItem(RegistryObject<Block> block, int butterflyIndex) {
        super((Block)block.get(), new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40750_));
        this.butterflyIndex = butterflyIndex;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        this.appendButterflyNameToHoverText(stack, components);
        MutableComponent newComponent = Component.m_237115_((String)"tooltip.butterflies.release_butterfly");
        Style style = newComponent.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)).m_131155_(Boolean.valueOf(true));
        newComponent.m_6270_(style);
        components.add((Component)newComponent);
        super.m_7373_(stack, level, components, tooltipFlag);
    }

    @Override
    public int getButterflyIndex() {
        return this.butterflyIndex;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack itemStack) {
        return Component.m_237115_((String)NAME);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ResourceLocation entity = this.getButterflyEntity(stack);
        if (entity != null) {
            Vec3 lookAngle = player.m_20154_();
            BlockPos positionToSpawn = player.m_20183_().m_7918_((int)lookAngle.f_82479_, (int)lookAngle.f_82480_ + 1, (int)lookAngle.f_82481_);
            Butterfly.spawn(player.f_19853_, entity, positionToSpawn, false);
        }
        player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @NotNull
    public InteractionResult m_40576_(@NotNull BlockPlaceContext context) {
        ItemStack stack;
        ResourceLocation entity;
        Player player;
        InteractionResult result = super.m_40576_(context);
        if (result == InteractionResult.CONSUME && (player = context.m_43723_()) != null && (entity = this.getButterflyEntity(stack = player.m_21120_(context.m_43724_()))) != null) {
            BlockPos position = context.m_8083_();
            Butterfly.spawn(player.m_9236_(), entity, position, true);
        }
        return result;
    }
}

