/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.model;

import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CaterpillarModel
extends HierarchicalModel<Caterpillar> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("butterflies", "caterpillar"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart thorax;

    public CaterpillarModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.thorax = this.body.m_171324_("thorax");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-3.0f, -5.0f, -6.0f, 6.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(20, 9).m_171488_(-5.0f, -7.0f, -2.0f, 10.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(18, 23).m_171488_(-2.0f, -3.0f, -8.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(20, 16).m_171488_(-5.0f, -7.0f, -6.0f, 10.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("thorax", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -4.0f, -2.0f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(-5.0f, -7.0f, 3.0f, 10.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(22, 0).m_171488_(-2.0f, -3.0f, 3.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@NotNull Caterpillar entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float ymod;
        float sin = (float)Math.sin(ageInTicks * 0.2f);
        this.head.f_104201_ = ymod = 0.5f * (sin + 1.0f);
        this.body.f_104201_ = 24.0f - ymod;
        this.thorax.f_104201_ = ymod;
        this.thorax.f_104202_ = -1.0f - sin;
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }
}

