/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.model;

import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class HummingbirdMothModel
extends HierarchicalModel<Butterfly> {
    private static final String ABDOMEN = "abdomen";
    private static final String ANTENNAE = "antennae";
    private static final String HEAD = "head";
    private static final String LEFT_WING = "left_wing";
    private static final String PROBOSCIS = "proboscis";
    private static final String RIGHT_WING = "right_wing";
    private static final String TAIL = "tail";
    private static final String THORAX = "thorax";
    private static final String WINGS = "wings";
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("butterflies", "hummingbird_moth"), "main");
    private final ModelPart thorax;
    private final ModelPart left_wing;
    private final ModelPart right_wing;

    public HummingbirdMothModel(ModelPart root) {
        this.thorax = root.m_171324_(THORAX);
        ModelPart wings = this.thorax.m_171324_(WINGS);
        this.left_wing = wings.m_171324_(LEFT_WING);
        this.right_wing = wings.m_171324_(RIGHT_WING);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition thorax = partdefinition.m_171599_(THORAX, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)0.0f));
        PartDefinition abdomen = thorax.m_171599_(ABDOMEN, CubeListBuilder.m_171558_().m_171514_(14, 0).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-1.0f));
        abdomen.m_171599_(TAIL, CubeListBuilder.m_171558_().m_171514_(14, 6).m_171488_(-3.0f, 0.0f, 3.0f, 6.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-1.0f));
        PartDefinition head = thorax.m_171599_(HEAD, CubeListBuilder.m_171558_().m_171514_(10, 9).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        head.m_171599_(ANTENNAE, CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-3.0f, -7.0f, -2.0f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_(PROBOSCIS, CubeListBuilder.m_171558_().m_171514_(0, -2).m_171488_(0.0f, -2.0f, -12.0f, 0.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wings = thorax.m_171599_(WINGS, CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)0.0f));
        wings.m_171599_(LEFT_WING, CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-13.0f, (float)1.0f));
        wings.m_171599_(RIGHT_WING, CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-13.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(@NotNull Butterfly entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float WING_ARC = 0.2f;
        float WING_SPEED = 13.0f;
        float BODY_ANGLE = 0.2853982f;
        float BODY_ARC = 0.15f;
        float BODY_SPEED = 0.1f;
        if (entity.getIsLanded()) {
            this.thorax.f_104203_ = 1.0853982f;
            this.right_wing.f_104204_ = 0.15f;
        } else {
            this.thorax.f_104203_ = 0.2853982f + Mth.m_14089_((float)(ageInTicks * 0.1f)) * 0.15f;
            this.right_wing.f_104204_ = Mth.m_14031_((float)(ageInTicks * 13.0f)) * (float)Math.PI * 0.2f;
        }
        this.left_wing.f_104204_ = -this.right_wing.f_104204_;
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.thorax;
    }
}

