/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class ForgeEventListener {
    public ForgeEventListener(IEventBus forgeEventBus) {
        forgeEventBus.register((Object)this);
        forgeEventBus.addListener(this::onTagsUpdated);
    }

    private void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            ForgeEventListener.addToPool(event.getRegistryAccess(), new ResourceLocation("village/plains/houses"), new ResourceLocation("butterflies", "village/plains/houses/plains_butterfly_house_1"), 6);
            ForgeEventListener.addToPool(event.getRegistryAccess(), new ResourceLocation("village/savanna/houses"), new ResourceLocation("butterflies", "village/savanna/houses/savanna_butterfly_house_1"), 4);
            ForgeEventListener.addToPool(event.getRegistryAccess(), new ResourceLocation("village/taiga/houses"), new ResourceLocation("butterflies", "village/taiga/houses/taiga_butterfly_house_1"), 4);
        }
    }

    private static void addToPool(RegistryAccess registryAccess, ResourceLocation structurePool, ResourceLocation structureToAdd, int weight) {
        Registry registry = registryAccess.m_175515_(Registries.f_256948_);
        StructureTemplatePool pool = Objects.requireNonNull((StructureTemplatePool)registry.m_7745_(structurePool), structurePool.m_135815_());
        if (!(pool.f_210559_ instanceof ArrayList)) {
            pool.f_210559_ = new ArrayList(pool.f_210559_);
        }
        SinglePoolElement addedElement = (SinglePoolElement)SinglePoolElement.m_210526_((String)structureToAdd.toString()).apply(StructureTemplatePool.Projection.RIGID);
        pool.f_210559_.add(Pair.of((Object)addedElement, (Object)weight));
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add((Object)addedElement);
        }
    }
}

