/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.entity.animal.Chrysalis;
import com.bokmcdok.butterflies.world.entity.animal.ParticleButterfly;
import com.bokmcdok.butterflies.world.entity.decoration.ButterflyScroll;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class EntityTypeRegistry {
    public static final MobCategory BUTTERFLY_SPAWN_POOL = MobCategory.create((String)"BUTTERFLY_SPAWNS", (String)"butterfly_spawns", (int)30, (boolean)true, (boolean)true, (int)128);
    private final DeferredRegister<EntityType<?>> deferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"butterflies");
    private BlockRegistry blockRegistry;
    private List<RegistryObject<EntityType<? extends Butterfly>>> butterflies;
    private List<RegistryObject<EntityType<ButterflyEgg>>> butterflyEggs;
    private RegistryObject<EntityType<IronGolem>> butterflyGolem;
    private RegistryObject<EntityType<ButterflyScroll>> butterflyScroll;
    private List<RegistryObject<EntityType<ButterflyScroll>>> butterflyScrolls;
    private List<RegistryObject<EntityType<Caterpillar>>> caterpillars;
    private List<RegistryObject<EntityType<Chrysalis>>> chrysalises;

    public EntityTypeRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(BlockRegistry blockRegistry) {
        this.blockRegistry = blockRegistry;
        int speciesCount = ButterflyInfo.SPECIES.length;
        this.butterflies = new ArrayList<RegistryObject<EntityType<? extends Butterfly>>>(speciesCount);
        this.butterflyEggs = new ArrayList<RegistryObject<EntityType<ButterflyEgg>>>(speciesCount);
        this.butterflyScrolls = new ArrayList<RegistryObject<EntityType<ButterflyScroll>>>(speciesCount);
        this.caterpillars = new ArrayList<RegistryObject<EntityType<Caterpillar>>>(speciesCount);
        this.chrysalises = new ArrayList<RegistryObject<EntityType<Chrysalis>>>(speciesCount);
        for (int i = 0; i < speciesCount; ++i) {
            this.butterflies.add(this.registerButterfly(i));
            this.butterflyEggs.add(this.registerButterflyEgg(i));
            this.butterflyScrolls.add(this.registerButterflyScroll(i));
            this.caterpillars.add(this.registerCaterpillar(i));
            this.chrysalises.add(this.registerChrysalis(i));
        }
        this.butterflyGolem = this.registerButterflyGolem();
        this.butterflyScroll = this.deferredRegister.register("butterfly_scroll", () -> EntityType.Builder.m_20704_(ButterflyScroll::create, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20712_("butterfly_scroll"));
    }

    public List<RegistryObject<EntityType<? extends Butterfly>>> getButterflies() {
        return this.butterflies;
    }

    public List<RegistryObject<EntityType<ButterflyEgg>>> getButterflyEggs() {
        return this.butterflyEggs;
    }

    public RegistryObject<EntityType<IronGolem>> getButterflyGolem() {
        return this.butterflyGolem;
    }

    public RegistryObject<EntityType<ButterflyScroll>> getButterflyScroll() {
        return this.butterflyScroll;
    }

    public List<RegistryObject<EntityType<ButterflyScroll>>> getButterflyScrolls() {
        return this.butterflyScrolls;
    }

    public List<RegistryObject<EntityType<Caterpillar>>> getCaterpillars() {
        return this.caterpillars;
    }

    public List<RegistryObject<EntityType<Chrysalis>>> getChrysalises() {
        return this.chrysalises;
    }

    private Butterfly createButterfly(EntityType<? extends Butterfly> entityType, Level level) {
        return new Butterfly(this.blockRegistry, entityType, level);
    }

    private Butterfly createIceButterfly(EntityType<? extends Butterfly> entityType, Level level) {
        return new ParticleButterfly(this.blockRegistry, entityType, level, ParticleTypes.f_175830_);
    }

    private Butterfly createLavaMoth(EntityType<? extends Butterfly> entityType, Level level) {
        return new ParticleButterfly(this.blockRegistry, entityType, level, ParticleTypes.f_175822_);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull EntityType.EntityFactory<Butterfly> getEntityFactory(int butterflyIndex) {
        ButterflyData.Trait[] traits;
        for (ButterflyData.Trait trait : traits = ButterflyInfo.TRAITS[butterflyIndex]) {
            if (trait == ButterflyData.Trait.ICY) {
                return this::createIceButterfly;
            }
            if (trait != ButterflyData.Trait.LAVA) continue;
            return this::createLavaMoth;
        }
        return this::createButterfly;
    }

    private RegistryObject<EntityType<? extends Butterfly>> registerButterfly(int butterflyIndex) {
        String registryId = Butterfly.getRegistryId(butterflyIndex);
        EntityType.EntityFactory<Butterfly> entityFactory = this.getEntityFactory(butterflyIndex);
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)entityFactory, (MobCategory)BUTTERFLY_SPAWN_POOL).m_20699_(0.3f, 0.2f).m_20702_(10).m_20712_(registryId));
    }

    private RegistryObject<EntityType<ButterflyEgg>> registerButterflyEgg(int butterflyIndex) {
        String registryId = ButterflyEgg.getRegistryId(butterflyIndex);
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.m_20704_(ButterflyEgg::new, (MobCategory)BUTTERFLY_SPAWN_POOL).m_20699_(0.1f, 0.1f).m_20712_(registryId));
    }

    private RegistryObject<EntityType<IronGolem>> registerButterflyGolem() {
        String registryId = "butterfly_golem";
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.m_20704_(IronGolem::new, (MobCategory)MobCategory.MISC).m_20699_(1.4f, 2.7f).m_20702_(10).m_20712_(registryId));
    }

    private RegistryObject<EntityType<ButterflyScroll>> registerButterflyScroll(int butterflyIndex) {
        String registryId = ButterflyScroll.getRegistryId(butterflyIndex);
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.m_20704_(ButterflyScroll::create, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20712_(registryId));
    }

    private RegistryObject<EntityType<Caterpillar>> registerCaterpillar(int butterflyIndex) {
        String registryId = Caterpillar.getRegistryId(butterflyIndex);
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.m_20704_(Caterpillar::new, (MobCategory)BUTTERFLY_SPAWN_POOL).m_20699_(0.1f, 0.1f).m_20712_(registryId));
    }

    private RegistryObject<EntityType<Chrysalis>> registerChrysalis(int butterflyIndex) {
        String registryId = Chrysalis.getRegistryId(butterflyIndex);
        return this.deferredRegister.register(registryId, () -> EntityType.Builder.m_20704_(Chrysalis::new, (MobCategory)BUTTERFLY_SPAWN_POOL).m_20699_(0.1f, 0.1f).m_20712_(registryId));
    }
}

