/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.common.loot.ButterflyLootModifier;
import com.bokmcdok.butterflies.common.loot.OakLeavesLootModifier;
import com.bokmcdok.butterflies.common.loot.TrailRuinsRareLootModifier;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class LootModifierRegistry {
    private final DeferredRegister<Codec<? extends IGlobalLootModifier>> deferredRegister = DeferredRegister.create((Supplier)ForgeRegistries.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"butterflies");

    public LootModifierRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(ItemRegistry itemRegistry) {
        this.deferredRegister.register("butterfly_loot", new ButterflyLootModifier(itemRegistry, new LootItemCondition[0]).getCodec());
        this.deferredRegister.register("oak_leaves_loot", new OakLeavesLootModifier(itemRegistry, new LootItemCondition[0]).getCodec());
        this.deferredRegister.register("trail_ruins_rare_loot", new TrailRuinsRareLootModifier(itemRegistry, new LootItemCondition[0]).getCodec());
    }
}

