/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.ai;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ButterflyEatCropGoal
extends MoveToBlockGoal {
    private final Butterfly butterfly;
    private CropBlock foodSource = null;
    private boolean hasEaten;

    public ButterflyEatCropGoal(Butterfly mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super((PathfinderMob)mob, speedModifier, searchRange, verticalSearchRange);
        Block potentialFoodSource;
        this.butterfly = mob;
        ButterflyData data = ButterflyData.getEntry(this.butterfly.getButterflyIndex());
        if (data != null && (potentialFoodSource = (Block)BuiltInRegistries.f_256975_.m_7745_(data.preferredFlower())) instanceof CropBlock) {
            CropBlock cropBlock;
            this.foodSource = cropBlock = (CropBlock)potentialFoodSource;
        }
    }

    public double m_8052_() {
        return 2.0;
    }

    public boolean m_8045_() {
        return this.butterfly.getIsActive() && super.m_8045_();
    }

    public boolean m_8036_() {
        return this.butterfly.getIsActive() && super.m_8036_();
    }

    public void m_8056_() {
        this.hasEaten = false;
        super.m_8056_();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.m_25625_()) {
            this.f_25601_ -= 11;
            Vec3 deltaMovement = this.butterfly.m_20184_();
            this.butterfly.m_20334_(0.0, deltaMovement.f_82480_, 0.0);
            if (!this.hasEaten) {
                int age;
                this.hasEaten = true;
                BlockState blockState = this.f_25598_.m_9236_().m_8055_(this.f_25602_);
                if (blockState.m_60713_((Block)this.foodSource) && (age = ((Integer)blockState.m_61143_((Property)CropBlock.f_52244_)).intValue()) > 0) {
                    blockState.m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(age - 1));
                    this.f_25598_.m_9236_().m_46597_(this.f_25602_, blockState);
                }
            }
        }
    }

    @NotNull
    public String toString() {
        return "Eat Crop / Food Source = [" + this.foodSource.toString() + "] / Target = [" + String.valueOf(this.m_6669_()) + "] / Reached Target = [" + this.m_25625_() + "] / Has Eaten = [" + this.hasEaten + "]";
    }

    protected boolean m_6465_(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos) {
        if (!levelReader.m_8055_(blockPos.m_7494_()).m_60795_()) {
            return false;
        }
        BlockState blockState = levelReader.m_8055_(blockPos);
        return blockState.m_60713_((Block)this.foodSource);
    }
}

