/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.world.ButterflyData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface ButterflyContainerItem {
    public int getButterflyIndex();

    default public void appendButterflyNameToHoverText(@NotNull ItemStack stack, @NotNull List<Component> components) {
        Object translatable = "item.butterflies.empty";
        ResourceLocation entity = this.getButterflyEntity(stack);
        if (entity != null) {
            translatable = "entity." + entity.toString().replace(':', '.');
        }
        MutableComponent newComponent = Component.m_237115_((String)translatable);
        Style style = newComponent.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_RED)).m_131155_(Boolean.valueOf(true));
        newComponent.m_6270_(style);
        components.add((Component)newComponent);
    }

    default public ResourceLocation getButterflyEntity(ItemStack stack) {
        ButterflyData data;
        CompoundTag tag;
        ResourceLocation entity = null;
        if (stack != null && (tag = stack.m_41784_()).m_128441_("EntityId")) {
            String entityId = tag.m_128461_("EntityId");
            entity = new ResourceLocation(entityId);
        }
        if (entity == null && (data = ButterflyData.getEntry(this.getButterflyIndex())) != null) {
            entity = data.getButterflyEntity();
        }
        return entity;
    }
}

