/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.gui.screens;

import com.bokmcdok.butterflies.client.texture.ButterflyTextures;
import com.bokmcdok.butterflies.world.ButterflyData;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyBookScreen
extends Screen {
    private List<FormattedCharSequence> cachedPageComponents = Collections.emptyList();
    private Component pageMsg = CommonComponents.EMPTY;
    private PageButton backButton;
    private PageButton forwardButton;
    private final BookAccess bookAccess;
    private int cachedPage = -1;
    private int currentPage;
    private final boolean playTurnSound;

    public ButterflyBookScreen(ItemStack stack) {
        this(new BookAccess(stack), true);
    }

    @Nullable
    public Style getClickedComponentStyleAt(double x, double y) {
        if (this.cachedPageComponents.isEmpty() || this.minecraft == null) {
            return null;
        }
        int i = Mth.floor((double)(x - (double)((this.width - 192) / 2) - 36.0));
        int j = Mth.floor((double)(y - 2.0 - 30.0));
        if (i >= 0 && j >= 0) {
            int k = Math.min(14, this.cachedPageComponents.size());
            if (i <= 114 && j < 9 * k + k) {
                int l = j / 9;
                if (l < this.cachedPageComponents.size()) {
                    FormattedCharSequence formattedCharSequence = this.cachedPageComponents.get(l);
                    return this.minecraft.font.getSplitter().componentStyleAtWidth(formattedCharSequence, i);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public boolean handleComponentClicked(Style style) {
        if (style != null) {
            ClickEvent clickEvent = style.getClickEvent();
            if (clickEvent == null) {
                return false;
            }
            if (clickEvent.getAction() == ClickEvent.Action.CHANGE_PAGE) {
                String clickEventValue = clickEvent.getValue();
                try {
                    int page = Integer.parseInt(clickEventValue) - 1;
                    return this.forcePage(page);
                }
                catch (Exception exception) {
                    return false;
                }
            }
            boolean flag = super.handleComponentClicked(style);
            if (flag && clickEvent.getAction() == ClickEvent.Action.RUN_COMMAND) {
                this.closeScreen();
            }
            return flag;
        }
        return false;
    }

    public boolean keyPressed(int key, int mod1, int mod2) {
        if (super.keyPressed(key, mod1, mod2)) {
            return true;
        }
        return switch (key) {
            case 266 -> {
                this.backButton.onPress();
                yield true;
            }
            case 267 -> {
                this.forwardButton.onPress();
                yield true;
            }
            default -> false;
        };
    }

    public boolean mouseClicked(double x, double y, int button) {
        Style style;
        if (button == 0 && (style = this.getClickedComponentStyleAt(x, y)) != null && this.handleComponentClicked(style)) {
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int x, int y, float unknown) {
        this.renderBackground(guiGraphics, x, y, unknown);
        int i = (this.width - 192) / 2;
        guiGraphics.blit(ButterflyTextures.BOOK, i, 2, 0, 0, 192, 192);
        if (this.cachedPage != this.currentPage) {
            FormattedText formattedText = this.bookAccess.getPage(this.currentPage);
            this.cachedPageComponents = this.font.split(formattedText, 114);
            this.pageMsg = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage + 1, Math.max(this.getNumPages(), 1)});
        }
        this.cachedPage = this.currentPage;
        if (this.cachedPage % 2 == 0) {
            int butterflyIndex = this.bookAccess.getButterflyIndex(this.cachedPage);
            ButterflyData data = ButterflyData.getEntry(butterflyIndex);
            if (data != null) {
                guiGraphics.blit(data.getScrollTexture(), i, 2, 0, 0, 192, 192);
            }
        } else {
            int cachedPageSize = Math.min(14, this.cachedPageComponents.size());
            for (int line = 0; line < cachedPageSize; ++line) {
                FormattedCharSequence formattedCharSequence = this.cachedPageComponents.get(line);
                guiGraphics.drawString(this.font, formattedCharSequence, i + 36, 32 + line * 9, 0, false);
            }
        }
        int fontWidth = this.font.width((FormattedText)this.pageMsg);
        guiGraphics.drawString(this.font, this.pageMsg, i - fontWidth + 192 - 44, 18, 0, false);
        Style style = this.getClickedComponentStyleAt(x, y);
        if (style != null) {
            guiGraphics.renderComponentHoverEffect(this.font, style, x, y);
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, x, y, unknown);
        }
    }

    public boolean setPage(int page) {
        int i = Mth.clamp((int)page, (int)0, (int)(this.bookAccess.getPageCount() - 1));
        if (i != this.currentPage) {
            this.currentPage = i;
            this.updateButtonVisibility();
            this.cachedPage = -1;
            return true;
        }
        return false;
    }

    protected void closeScreen() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(null);
        }
    }

    protected void createMenuControls() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - 100, 196, 200, 20).build());
    }

    protected void createPageControlButtons() {
        int i = (this.width - 192) / 2;
        this.forwardButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(i + 116, 159, true, button -> this.pageForward(), this.playTurnSound));
        this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(i + 43, 159, false, button -> this.pageBack(), this.playTurnSound));
        this.updateButtonVisibility();
    }

    protected boolean forcePage(int page) {
        return this.setPage(page);
    }

    protected void init() {
        this.createMenuControls();
        this.createPageControlButtons();
    }

    protected void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        this.updateButtonVisibility();
    }

    protected void pageForward() {
        if (this.currentPage < this.getNumPages() - 1) {
            ++this.currentPage;
        }
        this.updateButtonVisibility();
    }

    private ButterflyBookScreen(BookAccess access, boolean playTurnSound) {
        super(GameNarrator.NO_TITLE);
        this.bookAccess = access;
        this.playTurnSound = playTurnSound;
    }

    private int getNumPages() {
        return this.bookAccess.getPageCount();
    }

    private void updateButtonVisibility() {
        this.forwardButton.visible = this.currentPage < this.getNumPages() - 1;
        this.backButton.visible = this.currentPage > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BookAccess {
        private ListTag pages;

        public BookAccess(ItemStack stack) {
            CompoundTag tag = stack.getTag();
            if (tag != null) {
                this.pages = tag.getList("pages", 3);
            }
        }

        public int getButterflyIndex(int page) {
            if (this.pages != null) {
                return this.pages.getInt(page / 2);
            }
            return 0;
        }

        public FormattedText getPage(int page) {
            return page >= 0 && page < this.getPageCount() ? this.getPageRaw(page) : FormattedText.EMPTY;
        }

        public int getPageCount() {
            if (this.pages != null) {
                return this.pages.size() * 2;
            }
            return 0;
        }

        public FormattedText getPageRaw(int page) {
            if (this.pages != null) {
                int butterflyIndex = this.pages.getInt((page - 1) / 2);
                return ButterflyData.getFormattedButterflyData(butterflyIndex);
            }
            return null;
        }
    }
}

