/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.model;

import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CaterpillarModel
extends HierarchicalModel<Caterpillar> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("butterflies", "caterpillar"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart thorax;

    public CaterpillarModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.thorax = this.body.getChild("thorax");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 9).addBox(-3.0f, -5.0f, -6.0f, 6.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(20, 9).addBox(-5.0f, -7.0f, -2.0f, 10.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(18, 23).addBox(-2.0f, -3.0f, -8.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(20, 16).addBox(-5.0f, -7.0f, -6.0f, 10.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("thorax", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.0f, -2.0f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(-5.0f, -7.0f, 3.0f, 10.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(22, 0).addBox(-2.0f, -3.0f, 3.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@NotNull Caterpillar entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float ymod;
        float sin = (float)Math.sin(ageInTicks * 0.2f);
        this.head.y = ymod = 0.5f * (sin + 1.0f);
        this.body.y = 24.0f - ymod;
        this.thorax.y = ymod;
        this.thorax.z = -1.0f - sin;
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }
}

