/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.model;

import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class HummingbirdMothModel
extends HierarchicalModel<Butterfly> {
    private static final String ABDOMEN = "abdomen";
    private static final String ANTENNAE = "antennae";
    private static final String HEAD = "head";
    private static final String LEFT_WING = "left_wing";
    private static final String PROBOSCIS = "proboscis";
    private static final String RIGHT_WING = "right_wing";
    private static final String TAIL = "tail";
    private static final String THORAX = "thorax";
    private static final String WINGS = "wings";
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("butterflies", "hummingbird_moth"), "main");
    private final ModelPart thorax;
    private final ModelPart left_wing;
    private final ModelPart right_wing;

    public HummingbirdMothModel(ModelPart root) {
        this.thorax = root.getChild(THORAX);
        ModelPart wings = this.thorax.getChild(WINGS);
        this.left_wing = wings.getChild(LEFT_WING);
        this.right_wing = wings.getChild(RIGHT_WING);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition thorax = partdefinition.addOrReplaceChild(THORAX, CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        PartDefinition abdomen = thorax.addOrReplaceChild(ABDOMEN, CubeListBuilder.create().texOffs(14, 0).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)-1.0f));
        abdomen.addOrReplaceChild(TAIL, CubeListBuilder.create().texOffs(14, 6).addBox(-3.0f, 0.0f, 3.0f, 6.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)-1.0f));
        PartDefinition head = thorax.addOrReplaceChild(HEAD, CubeListBuilder.create().texOffs(10, 9).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        head.addOrReplaceChild(ANTENNAE, CubeListBuilder.create().texOffs(0, 15).addBox(-3.0f, -7.0f, -2.0f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild(PROBOSCIS, CubeListBuilder.create().texOffs(0, -2).addBox(0.0f, -2.0f, -12.0f, 0.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wings = thorax.addOrReplaceChild(WINGS, CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        wings.addOrReplaceChild(LEFT_WING, CubeListBuilder.create().texOffs(0, 4).addBox(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-13.0f, (float)1.0f));
        wings.addOrReplaceChild(RIGHT_WING, CubeListBuilder.create().texOffs(0, 4).addBox(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-13.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(@NotNull Butterfly entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float WING_ARC = 0.2f;
        float WING_SPEED = 13.0f;
        float BODY_ANGLE = 0.2853982f;
        float BODY_ARC = 0.15f;
        float BODY_SPEED = 0.1f;
        if (entity.getIsLanded()) {
            this.thorax.xRot = 1.0853982f;
            this.right_wing.yRot = 0.15f;
        } else {
            this.thorax.xRot = 0.2853982f + Mth.cos((float)(ageInTicks * 0.1f)) * 0.15f;
            this.right_wing.yRot = Mth.sin((float)(ageInTicks * 13.0f)) * (float)Math.PI * 0.2f;
        }
        this.left_wing.yRot = -this.right_wing.yRot;
    }

    @NotNull
    public ModelPart root() {
        return this.thorax;
    }
}

