/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.renderer.entity;

import com.bokmcdok.butterflies.client.renderer.entity.EntityDebugInfoRenderer;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class ButterflyBaseRenderer<T extends Butterfly, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    public ButterflyBaseRenderer(EntityRendererProvider.Context context, M entityModel, float shadowRadius) {
        super(context, entityModel, shadowRadius);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        return ((Butterfly)entity).getTexture();
    }

    protected void renderDebugInfo(@NotNull T entity, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLightCoordinates) {
        EntityDebugInfoRenderer.renderDebugInfo(entity, poseStack, multiBufferSource, this.entityRenderDispatcher.cameraOrientation(), this.getFont(), packedLightCoordinates);
    }

    protected void rotateIfLanded(@NotNull T entity, @NotNull PoseStack poseStack) {
        if (((Butterfly)entity).getIsLanded()) {
            switch (((Butterfly)entity).getLandedDirection()) {
                case UP: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    break;
                }
                case NORTH: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    break;
                }
                case SOUTH: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    break;
                }
                case EAST: {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    break;
                }
                case WEST: {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                    break;
                }
            }
        }
    }

    protected void scale(@NotNull Butterfly entity, PoseStack poses, float scale) {
        float s = entity.getRenderScale();
        poses.scale(s, s, s);
    }
}

