/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event;

import com.bokmcdok.butterflies.network.protocol.common.custom.ClientBoundButterflyDataPacket;
import com.bokmcdok.butterflies.network.protocol.common.custom.ClientPayloadHandler;
import com.bokmcdok.butterflies.registries.CreativeTabRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import java.util.Objects;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public class ModEventListener {
    private final CreativeTabRegistry creativeTabRegistry;
    private final ItemRegistry itemRegistry;

    public ModEventListener(@NotNull IEventBus modEventBus, @NotNull CreativeTabRegistry creativeTabRegistry, @NotNull ItemRegistry itemRegistry) {
        modEventBus.register((Object)this);
        this.creativeTabRegistry = creativeTabRegistry;
        this.itemRegistry = itemRegistry;
    }

    @SubscribeEvent
    public void onBuildCreativeModeTabContents(@NotNull BuildCreativeModeTabContentsEvent event) {
        if (!Objects.equals(event.getTabKey(), this.creativeTabRegistry.getButterflyCreativeTab().getKey())) {
            return;
        }
        event.accept((ItemLike)this.itemRegistry.getEmptyButterflyNet().get());
        this.itemRegistry.getButterflyNets().forEach(x -> event.accept((ItemLike)x.get()));
        event.accept((ItemLike)this.itemRegistry.getBurntButterflyNet().get());
        this.itemRegistry.getButterflyEggs().forEach(x -> event.accept((ItemLike)x.get()));
        this.itemRegistry.getCaterpillars().forEach(x -> event.accept((ItemLike)x.get()));
        this.itemRegistry.getBottledButterflies().forEach(x -> event.accept((ItemLike)x.get()));
        this.itemRegistry.getBottledCaterpillars().forEach(x -> event.accept((ItemLike)x.get()));
        this.itemRegistry.getButterflyScrolls().forEach(x -> event.accept((ItemLike)x.get()));
        event.accept((ItemLike)this.itemRegistry.getButterflyBook().get());
        event.accept((ItemLike)this.itemRegistry.getZhuangziBook().get());
        event.accept((ItemLike)this.itemRegistry.getButterflyFeeder().get());
        event.accept((ItemLike)this.itemRegistry.getButterflyMicroscope().get());
        event.accept((ItemLike)this.itemRegistry.getInfestedApple().get());
        event.accept((ItemLike)this.itemRegistry.getSilk().get());
        this.itemRegistry.getButterflyOrigami().forEach(x -> event.accept((ItemLike)x.get()));
        event.accept((ItemLike)this.itemRegistry.getButterflyPotterySherd().get());
        event.accept((ItemLike)this.itemRegistry.getButterflyBannerPattern().get());
        this.itemRegistry.getEggSpawnEggs().forEach(x -> event.accept((ItemLike)x.get()));
        this.itemRegistry.getCaterpillarSpawnEggs().forEach(x -> event.accept((ItemLike)x.get()));
        this.itemRegistry.getChrysalisSpawnEggs().forEach(x -> event.accept((ItemLike)x.get()));
        this.itemRegistry.getButterflySpawnEggs().forEach(x -> event.accept((ItemLike)x.get()));
        event.accept((ItemLike)this.itemRegistry.getButterflyGolemSpawnEgg().get());
    }

    @SubscribeEvent
    private void onRegisterPayloadHandler(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("butterflies");
        registrar.play(ClientBoundButterflyDataPacket.ID, ClientBoundButterflyDataPacket::new, handler -> handler.client(ClientPayloadHandler.getInstance()::handleButterflyData));
    }
}

