/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.network.protocol.common.custom;

import com.bokmcdok.butterflies.world.ButterflyData;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public record ClientBoundButterflyDataPacket(Collection<ButterflyData> data) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("butterflies", "butterfly_data");

    public ClientBoundButterflyDataPacket(FriendlyByteBuf buffer) {
        this(buffer.readCollection(ArrayList::new, entry -> new ButterflyData(entry.readInt(), entry.readUtf(), (ButterflyData.Size)entry.readEnum(ButterflyData.Size.class), (ButterflyData.Speed)entry.readEnum(ButterflyData.Speed.class), (ButterflyData.Rarity)entry.readEnum(ButterflyData.Rarity.class), entry.readList(x -> (ButterflyData.Habitat)x.readEnum(ButterflyData.Habitat.class)), entry.readInt(), entry.readInt(), entry.readInt(), entry.readInt(), entry.readResourceLocation(), (ButterflyData.ButterflyType)entry.readEnum(ButterflyData.ButterflyType.class), (ButterflyData.Diurnality)entry.readEnum(ButterflyData.Diurnality.class), (ButterflyData.ExtraLandingBlocks)entry.readEnum(ButterflyData.ExtraLandingBlocks.class), (ButterflyData.PlantEffect)entry.readEnum(ButterflyData.PlantEffect.class), (ButterflyData.EggMultiplier)entry.readEnum(ButterflyData.EggMultiplier.class), entry.readBoolean(), entry.readBoolean(), entry.readList(x -> (ButterflyData.Trait)x.readEnum(ButterflyData.Trait.class)), entry.readUtf(), entry.readUtf(), entry.readUtf(), entry.readUtf())));
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeCollection(this.data, (collectionBuffer, i) -> {
            collectionBuffer.writeInt(i.butterflyIndex());
            collectionBuffer.writeUtf(i.entityId());
            collectionBuffer.writeEnum((Enum)i.size());
            collectionBuffer.writeEnum((Enum)i.speed());
            collectionBuffer.writeEnum((Enum)i.rarity());
            collectionBuffer.writeCollection(i.habitats(), FriendlyByteBuf::writeEnum);
            collectionBuffer.writeInt(i.eggLifespan());
            collectionBuffer.writeInt(i.caterpillarLifespan());
            collectionBuffer.writeInt(i.chrysalisLifespan());
            collectionBuffer.writeInt(i.butterflyLifespan());
            collectionBuffer.writeResourceLocation(i.preferredFlower());
            collectionBuffer.writeEnum((Enum)i.type());
            collectionBuffer.writeEnum((Enum)i.diurnality());
            collectionBuffer.writeEnum((Enum)i.extraLandingBlocks());
            collectionBuffer.writeEnum((Enum)i.plantEffect());
            collectionBuffer.writeEnum((Enum)i.eggMultiplier());
            collectionBuffer.writeBoolean(i.caterpillarSounds());
            collectionBuffer.writeBoolean(i.butterflySounds());
            collectionBuffer.writeCollection(i.traits(), FriendlyByteBuf::writeEnum);
            collectionBuffer.writeUtf(i.baseVariant());
            collectionBuffer.writeUtf(i.coldVariant());
            collectionBuffer.writeUtf(i.mateVariant());
            collectionBuffer.writeUtf(i.warmVariant());
        });
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }
}

