/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.registries.MenuTypeRegistry;
import com.bokmcdok.butterflies.world.block.entity.ButterflyFeederEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlockEntityTypeRegistry {
    private MenuTypeRegistry menuTypeRegistry;
    private final DeferredRegister<BlockEntityType<?>> deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"butterflies");
    private DeferredHolder<BlockEntityType<?>, BlockEntityType<ButterflyFeederEntity>> butterflyFeeder;

    public BlockEntityTypeRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(BlockRegistry blockRegistry, MenuTypeRegistry menuTypeRegistry) {
        this.menuTypeRegistry = menuTypeRegistry;
        this.butterflyFeeder = this.deferredRegister.register("butterfly_feeder", () -> BlockEntityType.Builder.of(this::createButterflyFeeder, (Block[])new Block[]{(Block)blockRegistry.getButterflyFeeder().value()}).build(null));
    }

    public DeferredHolder<BlockEntityType<?>, BlockEntityType<ButterflyFeederEntity>> getButterflyFeeder() {
        return this.butterflyFeeder;
    }

    private ButterflyFeederEntity createButterflyFeeder(BlockPos blockPos, BlockState blockState) {
        return new ButterflyFeederEntity(this.menuTypeRegistry, (BlockEntityType)this.butterflyFeeder.get(), blockPos, blockState);
    }
}

