/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BannerPatternRegistry;
import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.item.BottledButterflyItem;
import com.bokmcdok.butterflies.world.item.BottledCaterpillarItem;
import com.bokmcdok.butterflies.world.item.ButterflyBookItem;
import com.bokmcdok.butterflies.world.item.ButterflyEggItem;
import com.bokmcdok.butterflies.world.item.ButterflyNetItem;
import com.bokmcdok.butterflies.world.item.ButterflyScrollItem;
import com.bokmcdok.butterflies.world.item.ButterflyZhuangziItem;
import com.bokmcdok.butterflies.world.item.CaterpillarItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class ItemRegistry {
    private final DeferredRegister<Item> deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"butterflies");
    private BlockRegistry blockRegistry;
    private EntityTypeRegistry entityTypeRegistry;
    private DeferredHolder<Item, Item> emptyButterflyNet;
    private List<DeferredHolder<Item, Item>> butterflyNets;
    private DeferredHolder<Item, Item> burntButterflyNet;
    private List<DeferredHolder<Item, Item>> butterflyEggs;
    private List<DeferredHolder<Item, Item>> caterpillars;
    private List<DeferredHolder<Item, Item>> bottledButterflies;
    private List<DeferredHolder<Item, Item>> bottledCaterpillars;
    private List<DeferredHolder<Item, Item>> butterflyScrolls;
    private DeferredHolder<Item, Item> butterflyBook;
    private DeferredHolder<Item, Item> zhuangziBook;
    private DeferredHolder<Item, Item> butterflyFeeder;
    private DeferredHolder<Item, Item> butterflyMicroscope;
    private DeferredHolder<Item, Item> infestedApple;
    private DeferredHolder<Item, Item> silk;
    private List<DeferredHolder<Item, Item>> butterflyOrigami;
    private DeferredHolder<Item, Item> butterflyPotterySherd;
    private DeferredHolder<Item, Item> butterflyBannerPattern;
    private List<DeferredHolder<Item, Item>> eggSpawnEggs;
    private List<DeferredHolder<Item, Item>> chrysalisSpawnEggs;
    private List<DeferredHolder<Item, Item>> caterpillarSpawnEggs;
    private List<DeferredHolder<Item, Item>> butterflySpawnEggs;
    private DeferredHolder<Item, Item> butterflyGolemSpawnEgg;

    public ItemRegistry(@NotNull IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(@NotNull BannerPatternRegistry bannerPatternRegistry, @NotNull BlockRegistry blockRegistry, @NotNull EntityTypeRegistry entityTypeRegistry) {
        int i;
        int i2;
        this.blockRegistry = Objects.requireNonNull(blockRegistry, "blockRegistry cannot be null");
        this.entityTypeRegistry = Objects.requireNonNull(entityTypeRegistry, "entityTypeRegistry cannot be null");
        this.emptyButterflyNet = this.deferredRegister.register("butterfly_net", () -> new ButterflyNetItem(this, -1));
        this.butterflyNets = new ArrayList<DeferredHolder<Item, Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.butterflyNets.add(this.registerButterflyNet(i2));
        }
        this.burntButterflyNet = this.deferredRegister.register("butterfly_net_burnt", () -> new Item(new Item.Properties()));
        this.butterflyEggs = new ArrayList<DeferredHolder<Item, Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.butterflyEggs.add(this.registerButterflyEgg(i2));
        }
        this.caterpillars = new ArrayList<DeferredHolder<Item, Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.caterpillars.add(this.registerCaterpillar(i2));
        }
        this.bottledButterflies = new ArrayList<DeferredHolder<Item, Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.bottledButterflies.add(this.registerBottledButterfly(i2));
        }
        this.bottledCaterpillars = new ArrayList<DeferredHolder<Item, Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.bottledCaterpillars.add(this.registerBottledCaterpillar(i2));
        }
        this.butterflyScrolls = new ArrayList<DeferredHolder<Item, Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.butterflyScrolls.add(this.registerButterflyScroll(i2));
        }
        this.butterflyBook = this.deferredRegister.register("butterfly_book", ButterflyBookItem::new);
        this.zhuangziBook = this.deferredRegister.register("butterfly_zhuangzi", ButterflyZhuangziItem::new);
        this.butterflyFeeder = this.deferredRegister.register("butterfly_feeder", () -> new BlockItem((Block)blockRegistry.getButterflyFeeder().get(), new Item.Properties()));
        this.butterflyMicroscope = this.deferredRegister.register("butterfly_microscope", () -> new BlockItem((Block)blockRegistry.getButterflyMicroscope().get(), new Item.Properties()));
        this.infestedApple = this.deferredRegister.register("infested_apple", () -> new Item(new Item.Properties()));
        this.silk = this.deferredRegister.register("silk", () -> new Item(new Item.Properties()));
        this.butterflyOrigami = new ArrayList<DeferredHolder<Item, Item>>();
        for (DeferredHolder<Block, Block> block : blockRegistry.getButterflyOrigami()) {
            this.butterflyOrigami.add((DeferredHolder<Item, Item>)this.deferredRegister.register(block.getId().getPath(), () -> new BlockItem((Block)block.get(), new Item.Properties())));
        }
        this.butterflyPotterySherd = this.deferredRegister.register("butterfly_pottery_sherd", () -> new Item(new Item.Properties()));
        this.butterflyBannerPattern = this.deferredRegister.register("banner_pattern_butterfly", () -> new BannerPatternItem(bannerPatternRegistry.getButterflyBannerPatternTagKey(), new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON)));
        this.eggSpawnEggs = new ArrayList<DeferredHolder<Item, Item>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            this.eggSpawnEggs.add(this.registerButterflyEggSpawnEgg(i));
        }
        this.chrysalisSpawnEggs = new ArrayList<DeferredHolder<Item, Item>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            this.chrysalisSpawnEggs.add(this.registerChrysalisSpawnEgg(i));
        }
        this.caterpillarSpawnEggs = new ArrayList<DeferredHolder<Item, Item>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            this.caterpillarSpawnEggs.add(this.registerCaterpillarSpawnEgg(i));
        }
        this.butterflySpawnEggs = new ArrayList<DeferredHolder<Item, Item>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            this.butterflySpawnEggs.add(this.registerButterflySpawnEgg(i));
        }
        this.butterflyGolemSpawnEgg = this.deferredRegister.register("spawn_egg_golem_butterfly", () -> new SpawnEggItem((EntityType)entityTypeRegistry.getButterflyGolem().get(), 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
    }

    public List<DeferredHolder<Item, Item>> getBottledButterflies() {
        return this.bottledButterflies;
    }

    public List<DeferredHolder<Item, Item>> getBottledCaterpillars() {
        return this.bottledCaterpillars;
    }

    public DeferredHolder<Item, Item> getButterflyBannerPattern() {
        return this.butterflyBannerPattern;
    }

    public DeferredHolder<Item, Item> getButterflyBook() {
        return this.butterflyBook;
    }

    public DeferredHolder<Item, Item> getButterflyMicroscope() {
        return this.butterflyMicroscope;
    }

    public DeferredHolder<Item, Item> getBurntButterflyNet() {
        return this.burntButterflyNet;
    }

    public List<DeferredHolder<Item, Item>> getButterflyEggs() {
        return this.butterflyEggs;
    }

    public DeferredHolder<Item, Item> getButterflyNetFromIndex(int butterflyIndex) {
        if (butterflyIndex < 0) {
            return this.emptyButterflyNet;
        }
        if (Objects.equals(ButterflyInfo.SPECIES[butterflyIndex], "lava")) {
            return this.burntButterflyNet;
        }
        return this.butterflyNets.get(butterflyIndex);
    }

    public DeferredHolder<Item, Item> getButterflyFeeder() {
        return this.butterflyFeeder;
    }

    public List<DeferredHolder<Item, Item>> getButterflyNets() {
        return this.butterflyNets;
    }

    public List<DeferredHolder<Item, Item>> getButterflyOrigami() {
        return this.butterflyOrigami;
    }

    public DeferredHolder<Item, Item> getButterflyPotterySherd() {
        return this.butterflyPotterySherd;
    }

    public List<DeferredHolder<Item, Item>> getButterflyScrolls() {
        return this.butterflyScrolls;
    }

    public List<DeferredHolder<Item, Item>> getButterflySpawnEggs() {
        return this.butterflySpawnEggs;
    }

    public DeferredHolder<Item, Item> getButterflyGolemSpawnEgg() {
        return this.butterflyGolemSpawnEgg;
    }

    public List<DeferredHolder<Item, Item>> getCaterpillars() {
        return this.caterpillars;
    }

    public List<DeferredHolder<Item, Item>> getEggSpawnEggs() {
        return this.eggSpawnEggs;
    }

    public List<DeferredHolder<Item, Item>> getChrysalisSpawnEggs() {
        return this.chrysalisSpawnEggs;
    }

    public List<DeferredHolder<Item, Item>> getCaterpillarSpawnEggs() {
        return this.caterpillarSpawnEggs;
    }

    public DeferredHolder<Item, Item> getEmptyButterflyNet() {
        return this.emptyButterflyNet;
    }

    public DeferredHolder<Item, Item> getInfestedApple() {
        return this.infestedApple;
    }

    public DeferredHolder<Item, Item> getSilk() {
        return this.silk;
    }

    public DeferredHolder<Item, Item> getZhuangziBook() {
        return this.zhuangziBook;
    }

    private DeferredHolder<Item, Item> registerButterflyNet(int butterflyIndex) {
        return this.deferredRegister.register(ButterflyNetItem.getRegistryId(butterflyIndex), () -> new ButterflyNetItem(this, butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerBottledButterfly(int butterflyIndex) {
        return this.deferredRegister.register(BottledButterflyItem.getRegistryId(butterflyIndex), () -> new BottledButterflyItem(this.blockRegistry.getBottledButterflyBlocks().get(butterflyIndex), butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerBottledCaterpillar(int butterflyIndex) {
        return this.deferredRegister.register(BottledCaterpillarItem.getRegistryId(butterflyIndex), () -> new BottledCaterpillarItem(this.blockRegistry.getBottledCaterpillarBlocks().get(butterflyIndex), butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerButterflyEgg(int butterflyIndex) {
        return this.deferredRegister.register(ButterflyEggItem.getRegistryId(butterflyIndex), () -> new ButterflyEggItem(butterflyIndex, new Item.Properties()));
    }

    private DeferredHolder<Item, Item> registerButterflyScroll(int butterflyIndex) {
        return this.deferredRegister.register(ButterflyScrollItem.getRegistryId(butterflyIndex), () -> new ButterflyScrollItem(this.entityTypeRegistry, butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerCaterpillar(int butterflyIndex) {
        return this.deferredRegister.register(CaterpillarItem.getRegistryId(butterflyIndex), () -> new CaterpillarItem(Caterpillar.getRegistryId(butterflyIndex)));
    }

    private DeferredHolder<Item, Item> registerButterflyEggSpawnEgg(int butterflyIndex) {
        return this.deferredRegister.register("spawn_egg_egg_" + Butterfly.getRegistryId(butterflyIndex), () -> new SpawnEggItem((EntityType)this.entityTypeRegistry.getButterflyEggs().get(butterflyIndex).get(), 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
    }

    private DeferredHolder<Item, Item> registerCaterpillarSpawnEgg(int butterflyIndex) {
        return this.deferredRegister.register("spawn_egg_" + CaterpillarItem.getRegistryId(butterflyIndex), () -> new SpawnEggItem((EntityType)this.entityTypeRegistry.getCaterpillars().get(butterflyIndex).get(), 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
    }

    private DeferredHolder<Item, Item> registerChrysalisSpawnEgg(int butterflyIndex) {
        return this.deferredRegister.register("spawn_egg_chrysalis_" + Butterfly.getRegistryId(butterflyIndex), () -> new SpawnEggItem((EntityType)this.entityTypeRegistry.getChrysalises().get(butterflyIndex).get(), 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
    }

    private DeferredHolder<Item, Item> registerButterflySpawnEgg(int butterflyIndex) {
        return this.deferredRegister.register("spawn_egg_butterfly_" + Butterfly.getRegistryId(butterflyIndex), () -> new SpawnEggItem((EntityType)this.entityTypeRegistry.getButterflies().get(butterflyIndex).get(), 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
    }
}

