/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class FlowerCropBlock
extends CropBlock {
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0)};
    private final Block flowerBlock;

    public FlowerCropBlock(Block block) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block));
        this.flowerBlock = block;
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        Vec3 offset = blockState.getOffset(blockGetter, blockPos);
        return SHAPE_BY_AGE[this.getAge(blockState)].move(offset.x, offset.y, offset.z);
    }

    @NotNull
    public BlockState getStateForAge(int age) {
        return age == 7 ? this.flowerBlock.defaultBlockState() : super.getStateForAge(age);
    }

    protected boolean mayPlaceOn(BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos) {
        return blockState.is(Blocks.GRASS_BLOCK);
    }
}

