/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.ai;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ButterflyEatCropGoal
extends MoveToBlockGoal {
    private final Butterfly butterfly;
    private CropBlock foodSource = null;
    private boolean hasEaten;

    public ButterflyEatCropGoal(Butterfly mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super((PathfinderMob)mob, speedModifier, searchRange, verticalSearchRange);
        Block potentialFoodSource;
        this.butterfly = mob;
        ButterflyData data = ButterflyData.getEntry(this.butterfly.getButterflyIndex());
        if (data != null && (potentialFoodSource = (Block)BuiltInRegistries.BLOCK.get(data.preferredFlower())) instanceof CropBlock) {
            CropBlock cropBlock;
            this.foodSource = cropBlock = (CropBlock)potentialFoodSource;
        }
    }

    public double acceptedDistance() {
        return 2.0;
    }

    public boolean canContinueToUse() {
        return this.butterfly.getIsActive() && super.canContinueToUse();
    }

    public boolean canUse() {
        return this.butterfly.getIsActive() && super.canUse();
    }

    public void start() {
        this.hasEaten = false;
        super.start();
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget()) {
            this.tryTicks -= 11;
            Vec3 deltaMovement = this.butterfly.getDeltaMovement();
            this.butterfly.setDeltaMovement(0.0, deltaMovement.y, 0.0);
            if (!this.hasEaten) {
                int age;
                this.hasEaten = true;
                BlockState blockState = this.mob.level().getBlockState(this.blockPos);
                if (blockState.is((Block)this.foodSource) && (age = ((Integer)blockState.getValue((Property)CropBlock.AGE)).intValue()) > 0) {
                    blockState.setValue((Property)CropBlock.AGE, (Comparable)Integer.valueOf(age - 1));
                    this.mob.level().setBlockAndUpdate(this.blockPos, blockState);
                }
            }
        }
    }

    @NotNull
    public String toString() {
        return "Eat Crop / Food Source = [" + this.foodSource.toString() + "] / Target = [" + String.valueOf(this.getMoveToTarget()) + "] / Reached Target = [" + this.isReachedTarget() + "] / Has Eaten = [" + this.hasEaten + "]";
    }

    protected boolean isValidTarget(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos) {
        if (!levelReader.getBlockState(blockPos.above()).isAir()) {
            return false;
        }
        BlockState blockState = levelReader.getBlockState(blockPos);
        return blockState.is((Block)this.foodSource);
    }
}

