/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.animal;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.entity.animal.DirectionalCreature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;

public class ButterflyEgg
extends DirectionalCreature {
    public static String getRegistryId(int butterflyIndex) {
        return ButterflyInfo.SPECIES[butterflyIndex] + "_egg";
    }

    public static void spawn(ServerLevel level, ResourceLocation location, BlockPos spawnBlock, Direction surfaceDirection) {
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(location);
        Entity entity = entityType.create((Level)level);
        if (entity instanceof ButterflyEgg) {
            ButterflyEgg egg = (ButterflyEgg)entity;
            double x = (double)spawnBlock.getX() + level.random.nextDouble();
            double y = (double)spawnBlock.getY() + level.random.nextDouble();
            double z = (double)spawnBlock.getZ() + level.random.nextDouble();
            switch (surfaceDirection) {
                case WEST: {
                    x = spawnBlock.getX();
                    break;
                }
                case EAST: {
                    x = (double)spawnBlock.getX() + 1.0;
                    break;
                }
                case DOWN: {
                    y = spawnBlock.getY();
                    break;
                }
                case UP: {
                    y = (double)spawnBlock.getY() + 1.0;
                    break;
                }
                case NORTH: {
                    z = spawnBlock.getZ();
                    break;
                }
                case SOUTH: {
                    z = (double)spawnBlock.getZ() + 1.0;
                }
            }
            egg.moveTo(x, y, z, 0.0f, 0.0f);
            egg.setSurfaceDirection(surfaceDirection);
            egg.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(spawnBlock), MobSpawnType.NATURAL, null, null);
            level.addFreshEntity((Entity)egg);
        }
    }

    public float getRenderScale() {
        return 0.05f * this.getData().getSizeMultiplier();
    }

    public boolean hurt(@NotNull DamageSource damageSource, float damage) {
        Entity entity = damageSource.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.level().isClientSide) {
                player.playSound(SoundEvents.PLAYER_ATTACK_SWEEP, 1.0f, 1.0f);
            } else {
                this.remove(Entity.RemovalReason.DISCARDED);
                Item itemToAdd = (Item)BuiltInRegistries.ITEM.get(this.getData().getButterflyEggItem());
                ItemStack itemStack = new ItemStack((ItemLike)itemToAdd);
                player.addItem(itemStack);
            }
            return true;
        }
        return super.hurt(damageSource, damage);
    }

    public boolean isFood(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 64.0 * ButterflyEgg.getViewScale()) * d0;
    }

    public ButterflyEgg(EntityType<? extends ButterflyEgg> entityType, Level level) {
        super(entityType, level);
        String species = ButterflyData.getSpeciesString((LivingEntity)this);
        this.setTexture("textures/item/butterfly_egg/" + species + "_egg.png");
        this.setAge(-this.getData().eggLifespan());
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.level().isEmptyBlock(this.getSurfaceBlockPos())) {
            this.kill();
        }
        if (this.getAge() >= 0 && this.random.nextInt(0, 15) == 0) {
            ResourceLocation newLocation = this.getData().getCaterpillarEntity();
            Caterpillar.spawn((ServerLevel)this.level(), newLocation, this.blockPosition(), this.getDirection(), false);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void doPush(@NotNull Entity otherEntity) {
    }

    @NotNull
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected float getSoundVolume() {
        return 0.0f;
    }

    protected void pushEntities() {
    }
}

