/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.animal;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.DirectionalCreature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Chrysalis
extends DirectionalCreature {
    public static String getRegistryId(int butterflyIndex) {
        return ButterflyInfo.SPECIES[butterflyIndex] + "_chrysalis";
    }

    public static void spawn(ServerLevel level, ResourceLocation location, BlockPos spawnBlock, Direction surfaceDirection, Vec3 position, float yRotation) {
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(location);
        Entity entity = entityType.create((Level)level);
        if (entity instanceof Chrysalis) {
            Chrysalis chrysalis = (Chrysalis)entity;
            chrysalis.moveTo(position.x, position.y, position.z, 0.0f, 0.0f);
            chrysalis.setYRot(yRotation);
            chrysalis.setSurfaceDirection(surfaceDirection);
            chrysalis.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(spawnBlock), MobSpawnType.NATURAL, null, null);
            level.addFreshEntity((Entity)chrysalis);
        }
    }

    public float getRenderScale() {
        float scale = (float)this.getAge() / -24000.0f;
        scale *= 0.06f;
        return (scale += 0.1f) * this.getData().getSizeMultiplier();
    }

    public boolean isFood(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 64.0 * Chrysalis.getViewScale()) * d0;
    }

    public Chrysalis(EntityType<? extends Chrysalis> entityType, Level level) {
        super(entityType, level);
        String[] split;
        String species = "undiscovered";
        String encodeId = this.getEncodeId();
        if (encodeId != null && (split = encodeId.split(":")).length >= 2 && (split = (species = split[1]).split("_")).length >= 2) {
            species = split[0];
        }
        this.setTexture("textures/entity/chrysalis/chrysalis_" + species + ".png");
        this.setAge(-this.getData().chrysalisLifespan());
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.level().isEmptyBlock(this.getSurfaceBlockPos())) {
            this.kill();
        }
        if (this.getAge() >= 0 && this.random.nextInt(0, 15) == 0) {
            ButterflyData data;
            int mateIndex;
            int butterflyIndex = this.getData().getBaseButterflyIndex();
            float temperature = ((Biome)this.level().getBiome(this.blockPosition()).value()).getModifiedClimateSettings().temperature();
            if ((double)temperature < 0.5) {
                int coldIndex = this.getData().getColdButterflyIndex();
                if (coldIndex >= 0) {
                    butterflyIndex = coldIndex;
                }
            } else {
                int warmIndex = this.getData().getWarmButterflyIndex();
                if (warmIndex >= 0) {
                    butterflyIndex = warmIndex;
                }
            }
            if (this.random.nextInt() % 2 == 0 && (mateIndex = this.getData().getMateButterflyIndex()) >= 0) {
                butterflyIndex = mateIndex;
            }
            if ((data = ButterflyData.getEntry(butterflyIndex)) != null) {
                ResourceLocation newLocation = data.getButterflyEntity();
                Butterfly.spawn(this.level(), newLocation, this.blockPosition(), false);
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void doPush(@NotNull Entity otherEntity) {
    }

    @NotNull
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected float getSoundVolume() {
        return 0.0f;
    }

    protected void pushEntities() {
    }
}

