/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BottledCaterpillarItem
extends BlockItem {
    public static final String BOTTLED_CATERPILLAR_STRING = "block.butterflies.bottled_caterpillar";
    public static final String BOTTLED_LARVA_STRING = "block.butterflies.bottled_larva";
    private final int butterflyIndex;

    public static String getRegistryId(int butterflyIndex) {
        return "bottled_caterpillar_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    public BottledCaterpillarItem(DeferredHolder<Block, Block> block, int butterflyIndex) {
        super((Block)block.get(), new Item.Properties().stacksTo(1));
        this.butterflyIndex = butterflyIndex;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        ButterflyData data = ButterflyData.getEntry(this.butterflyIndex);
        if (data != null) {
            ResourceLocation caterpillarEntity = data.getCaterpillarEntity();
            String translatable = "entity." + caterpillarEntity.toString().replace(':', '.');
            MutableComponent speciesComponent = Component.translatable((String)translatable);
            Style speciesStyle = speciesComponent.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.DARK_RED)).withItalic(Boolean.valueOf(true));
            speciesComponent.setStyle(speciesStyle);
            components.add((Component)speciesComponent);
            MutableComponent tooltipComponent = Component.translatable((String)"tooltip.butterflies.release_caterpillar");
            Style tooltipStyle = tooltipComponent.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withItalic(Boolean.valueOf(true));
            tooltipComponent.setStyle(tooltipStyle);
            components.add((Component)tooltipComponent);
            super.appendHoverText(stack, level, components, tooltipFlag);
        }
    }

    @NotNull
    public Component getName(@NotNull ItemStack itemStack) {
        ButterflyData data = ButterflyData.getEntry(this.butterflyIndex);
        if (data != null && data.type() == ButterflyData.ButterflyType.MOTH) {
            return Component.translatable((String)BOTTLED_LARVA_STRING);
        }
        return Component.translatable((String)BOTTLED_CATERPILLAR_STRING);
    }

    @NotNull
    public InteractionResult place(@NotNull BlockPlaceContext context) {
        ButterflyData data;
        InteractionResult result = super.place(context);
        if (result == InteractionResult.CONSUME && (data = ButterflyData.getEntry(this.butterflyIndex)) != null) {
            Caterpillar.spawn((ServerLevel)context.getLevel(), data.getCaterpillarEntity(), context.getClickedPos(), Direction.DOWN, true);
        }
        return result;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ButterflyData data = ButterflyData.getEntry(this.butterflyIndex);
        if (data != null) {
            ResourceLocation location = data.getCaterpillarItem();
            Item caterpillarItem = (Item)BuiltInRegistries.ITEM.get(location);
            ItemStack caterpillarStack = new ItemStack((ItemLike)caterpillarItem, 1);
            player.addItem(caterpillarStack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }
}

