/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.client.gui.screens.ButterflyBookScreen;
import com.bokmcdok.butterflies.world.ButterflyData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButterflyBookItem
extends Item {
    public static final String NAME = "butterfly_book";

    public static boolean addPage(@NotNull ItemStack newBook, int index) {
        boolean result = false;
        ListTag newPages = new ListTag();
        CompoundTag tag = newBook.getOrCreateTag();
        if (tag.contains("pages")) {
            newPages = tag.getList("pages", 3);
        }
        if (!newPages.contains((Object)IntTag.valueOf((int)index))) {
            newPages.add((Object)IntTag.valueOf((int)index));
            result = true;
        }
        int numButterflies = 0;
        int numMoths = 0;
        for (Tag i : newPages) {
            IntTag intTag;
            ButterflyData data;
            if (!(i instanceof IntTag) || (data = ButterflyData.getEntry((intTag = (IntTag)i).getAsInt())) == null) continue;
            if (data.type() == ButterflyData.ButterflyType.BUTTERFLY) {
                ++numButterflies;
                continue;
            }
            if (data.type() != ButterflyData.ButterflyType.MOTH) continue;
            ++numMoths;
        }
        CompoundTag newTag = newBook.getOrCreateTag();
        newTag.put("pages", (Tag)newPages);
        int customModelData = 0;
        if (numButterflies >= ButterflyData.getNumButterflySpecies()) {
            ++customModelData;
        }
        if (numMoths >= ButterflyData.getNumMothSpecies()) {
            customModelData += 2;
        }
        newTag.putInt("CustomModelData", customModelData);
        return result;
    }

    public ButterflyBookItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        String localisation = "tooltip.butterflies.pages";
        int numPages = 0;
        CompoundTag tag = stack.getOrCreateTag();
        if (tag.contains("pages")) {
            ListTag newPages = tag.getList("pages", 3);
            numPages = 2 * newPages.size();
        }
        MutableComponent newComponent = Component.translatable((String)localisation, (Object[])new Object[]{numPages});
        Style style = newComponent.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.DARK_RED)).withItalic(Boolean.valueOf(true));
        newComponent.setStyle(style);
        components.add((Component)newComponent);
        super.appendHoverText(stack, level, components, tooltipFlag);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            this.openScreen(itemStack);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen(ItemStack book) {
        Minecraft.getInstance().setScreen((Screen)new ButterflyBookScreen(book));
    }
}

