/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.client.gui.screens.ButterflyScrollScreen;
import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.decoration.ButterflyScroll;
import com.bokmcdok.butterflies.world.item.ButterflyContainerItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButterflyScrollItem
extends Item
implements ButterflyContainerItem {
    private final EntityTypeRegistry entityTypeRegistry;
    public static final String BUTTERFLY_SCROLL_STRING = "item.butterflies.butterfly_scroll";
    public static final String MOTH_SCROLL_STRING = "item.butterflies.moth_scroll";
    private final int butterflyIndex;

    public static String getRegistryId(int butterflyIndex) {
        return "butterfly_scroll_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    public ButterflyScrollItem(EntityTypeRegistry entityTypeRegistry, int butterflyIndex) {
        super(new Item.Properties());
        this.entityTypeRegistry = entityTypeRegistry;
        this.butterflyIndex = butterflyIndex;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        this.appendButterflyNameToHoverText(stack, components);
        MutableComponent newComponent = Component.translatable((String)"tooltip.butterflies.scroll");
        Style style = newComponent.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withItalic(Boolean.valueOf(true));
        newComponent.setStyle(style);
        components.add((Component)newComponent);
        super.appendHoverText(stack, level, components, tooltipFlag);
    }

    @Override
    public int getButterflyIndex() {
        return this.butterflyIndex;
    }

    @NotNull
    public Component getName(@NotNull ItemStack itemStack) {
        ButterflyData data = ButterflyData.getEntry(this.butterflyIndex);
        if (data != null && data.type() == ButterflyData.ButterflyType.MOTH) {
            return Component.translatable((String)MOTH_SCROLL_STRING);
        }
        return Component.translatable((String)BUTTERFLY_SCROLL_STRING);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            CompoundTag tag = itemstack.getTag();
            if (tag != null && tag.contains("CustomModelData")) {
                this.openScreen(tag.getInt("CustomModelData"));
            } else if (this.getButterflyIndex() >= 0) {
                this.openScreen(this.getButterflyIndex());
            } else {
                this.replaceWithPaper(player, hand, itemstack);
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null) {
            BlockPos clickedPos = context.getClickedPos();
            Direction clickedFace = context.getClickedFace();
            BlockPos blockPos = clickedPos.relative(clickedFace);
            ItemStack itemInHand = context.getItemInHand();
            if (!this.mayPlace(player, clickedFace, itemInHand, blockPos)) {
                return InteractionResult.FAIL;
            }
            Level level = context.getLevel();
            int butterflyIndex = this.getButterflyIndex();
            List<DeferredHolder<EntityType<?>, EntityType<ButterflyScroll>>> butterflyScrolls = this.entityTypeRegistry.getButterflyScrolls();
            if (butterflyIndex >= 0 && butterflyIndex < butterflyScrolls.size()) {
                DeferredHolder<EntityType<?>, EntityType<ButterflyScroll>> entityType = butterflyScrolls.get(butterflyIndex);
                ButterflyScroll butterflyScroll = new ButterflyScroll((EntityType<ButterflyScroll>)((EntityType)entityType.get()), level, blockPos, clickedFace);
                if (butterflyScroll.survives()) {
                    if (!level.isClientSide) {
                        butterflyScroll.playPlacementSound();
                        level.gameEvent((Entity)player, GameEvent.ENTITY_PLACE, butterflyScroll.position());
                        level.addFreshEntity((Entity)butterflyScroll);
                    }
                    itemInHand.shrink(1);
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                return InteractionResult.CONSUME;
            }
            this.replaceWithPaper(player, context.getHand(), itemInHand);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(context);
    }

    protected boolean mayPlace(Player player, Direction direction, ItemStack itemStack, BlockPos blockPos) {
        return !direction.getAxis().isVertical() && player.mayUseItemAt(blockPos, direction, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen(int butterflyIndex) {
        Minecraft.getInstance().setScreen((Screen)new ButterflyScrollScreen(butterflyIndex));
    }

    private void replaceWithPaper(@NotNull Player player, @NotNull InteractionHand hand, ItemStack stack) {
        player.setItemInHand(hand, new ItemStack((ItemLike)Items.PAPER, stack.getCount()));
        player.addItem(new ItemStack((ItemLike)Items.IRON_NUGGET, stack.getCount()));
    }
}

