/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event.network;

import com.bokmcdok.butterflies.network.protocol.common.custom.ClientBoundButterflyDataPacket;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.DataFormatException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class NetworkEventListener {
    public NetworkEventListener(IEventBus forgeEventBus) {
        forgeEventBus.register((Object)this);
        forgeEventBus.addListener(this::onDatapackSync);
        forgeEventBus.addListener(this::onCustomPayload);
    }

    private void onDatapackSync(OnDatapackSyncEvent event) {
        Collection<ButterflyData> butterflyDataCollection = ButterflyData.getButterflyDataCollection();
        ClientBoundButterflyDataPacket packet = new ClientBoundButterflyDataPacket(butterflyDataCollection);
        ClientboundCustomPayloadPacket payload = new ClientboundCustomPayloadPacket((CustomPacketPayload)packet);
        if (event.getPlayer() != null) {
            event.getPlayer().f_8906_.m_141995_((Packet)payload);
        } else if (event.getPlayerList() != null) {
            for (ServerPlayer i : event.getPlayerList().m_11314_()) {
                i.f_8906_.m_141995_((Packet)payload);
            }
        }
    }

    private void onCustomPayload(CustomPayloadEvent event) {
        FriendlyByteBuf payload;
        if (event.getChannel().compareTo(ClientBoundButterflyDataPacket.ID) == 0 && (payload = event.getPayload()) != null) {
            List butterflyData = (List)payload.m_236838_(ArrayList::new, buffer -> new ButterflyData(buffer.readInt(), buffer.m_130277_(), (ButterflyData.Size)buffer.m_130066_(ButterflyData.Size.class), (ButterflyData.Speed)buffer.m_130066_(ButterflyData.Speed.class), (ButterflyData.Rarity)buffer.m_130066_(ButterflyData.Rarity.class), (ButterflyData.Habitat)buffer.m_130066_(ButterflyData.Habitat.class), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.m_130281_(), (ButterflyData.ButterflyType)buffer.m_130066_(ButterflyData.ButterflyType.class), (ButterflyData.Diurnality)buffer.m_130066_(ButterflyData.Diurnality.class), (ButterflyData.ExtraLandingBlocks)buffer.m_130066_(ButterflyData.ExtraLandingBlocks.class), (ButterflyData.PlantEffect)buffer.m_130066_(ButterflyData.PlantEffect.class), buffer.m_130281_(), (ButterflyData.EggMultiplier)buffer.m_130066_(ButterflyData.EggMultiplier.class), buffer.readBoolean(), buffer.readBoolean()));
            for (ButterflyData butterfly : butterflyData) {
                try {
                    ButterflyData.addButterfly(butterfly);
                }
                catch (DataFormatException e) {
                    LogUtils.getLogger().error("Received invalid butterfly data.", (Throwable)e);
                }
            }
        }
    }
}

