/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ButterflyOrigamiBlock
extends Block {
    public static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.f_61375_;
    private final VoxelShape northAabb;
    private final VoxelShape southAabb;
    private final VoxelShape eastAabb;
    private final VoxelShape westAabb;
    private final VoxelShape upAabb;
    private final VoxelShape downAabb;

    public ButterflyOrigamiBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60910_().m_60913_(0.5f, 2.5f).m_60918_(SoundType.f_271137_));
        this.m_49959_((BlockState)this.m_49966_().m_61124_(ORIENTATION, (Comparable)FrontAndTop.NORTH_UP));
        this.upAabb = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
        this.downAabb = Block.m_49796_((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        this.northAabb = Block.m_49796_((double)1.0, (double)1.0, (double)12.0, (double)15.0, (double)15.0, (double)16.0);
        this.southAabb = Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)4.0);
        this.eastAabb = Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)4.0, (double)15.0, (double)15.0);
        this.westAabb = Block.m_49796_((double)12.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos pos) {
        Direction direction = ((FrontAndTop)blockState.m_61143_(ORIENTATION)).m_122625_();
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        return levelReader.m_8055_(blockPos).m_60783_((BlockGetter)levelReader, blockPos, direction);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext collisionContext) {
        Direction direction = ((FrontAndTop)blockState.m_61143_(ORIENTATION)).m_122625_();
        return switch (direction) {
            case Direction.NORTH -> this.northAabb;
            case Direction.SOUTH -> this.southAabb;
            case Direction.EAST -> this.eastAabb;
            case Direction.WEST -> this.westAabb;
            case Direction.DOWN -> this.downAabb;
            default -> this.upAabb;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Direction direction = blockPlaceContext.m_43719_();
        return (BlockState)this.m_49966_().m_61124_(ORIENTATION, (Comparable)(switch (direction) {
            case Direction.NORTH -> FrontAndTop.NORTH_UP;
            case Direction.SOUTH -> FrontAndTop.SOUTH_UP;
            case Direction.EAST -> FrontAndTop.EAST_UP;
            case Direction.WEST -> FrontAndTop.WEST_UP;
            default -> {
                Direction horizontalDirection = blockPlaceContext.m_8125_();
                switch (horizontalDirection) {
                    case EAST: {
                        yield direction == Direction.UP ? FrontAndTop.UP_EAST : FrontAndTop.DOWN_EAST;
                    }
                    case WEST: {
                        yield direction == Direction.UP ? FrontAndTop.UP_WEST : FrontAndTop.DOWN_WEST;
                    }
                    case SOUTH: {
                        yield direction == Direction.UP ? FrontAndTop.UP_SOUTH : FrontAndTop.DOWN_SOUTH;
                    }
                }
                yield direction == Direction.UP ? FrontAndTop.UP_NORTH : FrontAndTop.DOWN_NORTH;
            }
        }));
    }

    @NotNull
    public BlockState m_7417_(BlockState thisBlockState, Direction direction, @NotNull BlockState otherBlockState, @NotNull LevelAccessor levelAccessor, @NotNull BlockPos thisBlockPos, @NotNull BlockPos otherBlockPos) {
        return direction.m_122424_() == ((FrontAndTop)thisBlockState.m_61143_(ORIENTATION)).m_122625_() && !thisBlockState.m_60710_((LevelReader)levelAccessor, thisBlockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(thisBlockState, direction, otherBlockState, levelAccessor, thisBlockPos, otherBlockPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{ORIENTATION});
    }
}

