/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.animal;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.entity.animal.DirectionalCreature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ButterflyEgg
extends DirectionalCreature {
    public static String getRegistryId(int butterflyIndex) {
        return ButterflySpeciesList.SPECIES[butterflyIndex] + "_egg";
    }

    public static void spawn(ServerLevel level, ResourceLocation location, BlockPos spawnBlock, Direction surfaceDirection) {
        Entity entity;
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location);
        if (entityType != null && (entity = entityType.m_20615_((Level)level)) instanceof ButterflyEgg) {
            ButterflyEgg egg = (ButterflyEgg)entity;
            double x = (double)spawnBlock.m_123341_() + level.f_46441_.m_188500_();
            double y = (double)spawnBlock.m_123342_() + level.f_46441_.m_188500_();
            double z = (double)spawnBlock.m_123343_() + level.f_46441_.m_188500_();
            switch (surfaceDirection) {
                case WEST: {
                    x = spawnBlock.m_123341_();
                    break;
                }
                case EAST: {
                    x = (double)spawnBlock.m_123341_() + 1.0;
                    break;
                }
                case DOWN: {
                    y = spawnBlock.m_123342_();
                    break;
                }
                case UP: {
                    y = (double)spawnBlock.m_123342_() + 1.0;
                    break;
                }
                case NORTH: {
                    z = spawnBlock.m_123343_();
                    break;
                }
                case SOUTH: {
                    z = (double)spawnBlock.m_123343_() + 1.0;
                }
            }
            egg.m_7678_(x, y, z, 0.0f, 0.0f);
            egg.setSurfaceDirection(surfaceDirection);
            egg.m_6518_((ServerLevelAccessor)level, level.m_6436_(spawnBlock), MobSpawnType.NATURAL, null, null);
            level.m_7967_((Entity)egg);
        }
    }

    public float getRenderScale() {
        return 0.05f * this.getData().getSizeMultiplier();
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float damage) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.m_9236_().f_46443_) {
                player.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
            } else {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                Item itemToAdd = (Item)ForgeRegistries.ITEMS.getValue(this.getData().getButterflyEggItem());
                if (itemToAdd != null) {
                    ItemStack itemStack = new ItemStack((ItemLike)itemToAdd);
                    player.m_36356_(itemStack);
                }
            }
            return true;
        }
        return super.m_6469_(damageSource, damage);
    }

    public boolean m_6898_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_146762_(int age) {
        this.f_146733_ = age;
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 64.0 * ButterflyEgg.m_20150_()) * d0;
    }

    public ButterflyEgg(EntityType<? extends ButterflyEgg> entityType, Level level) {
        super(entityType, level);
        String species = ButterflyData.getSpeciesString((LivingEntity)this);
        this.setTexture("textures/item/butterfly_egg/" + species + "_egg.png");
        this.m_146762_(-this.getData().eggLifespan());
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.m_9236_().m_46859_(this.getSurfaceBlockPos())) {
            this.m_6074_();
        }
        if (this.m_146764_() >= 0 && this.f_19796_.m_216339_(0, 15) == 0) {
            ResourceLocation newLocation = this.getData().getCaterpillarEntity();
            Caterpillar.spawn((ServerLevel)this.m_9236_(), newLocation, this.m_20183_(), this.m_6350_(), false);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_7324_(@NotNull Entity otherEntity) {
    }

    @NotNull
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected float m_6121_() {
        return 0.0f;
    }

    protected void m_6138_() {
    }
}

