/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.decoration;

import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButterflyScroll
extends HangingEntity {
    private ItemRegistry itemRegistry;
    public static final String NAME = "butterfly_scroll";
    private int butterflyIndex;

    @NotNull
    public static ButterflyScroll create(EntityType<? extends ButterflyScroll> entityType, Level level) {
        return new ButterflyScroll(entityType, level);
    }

    public ButterflyScroll(EntityTypeRegistry entityTypeRegistry, ItemRegistry itemRegistry, Level level, BlockPos blockPos, Direction direction) {
        this((EntityType<? extends ButterflyScroll>)((EntityType)entityTypeRegistry.getButterflyScroll().get()), level);
        this.itemRegistry = itemRegistry;
        this.f_31698_ = blockPos;
        this.m_6022_(direction);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("Facing", (byte)this.f_31699_.m_122411_());
        tag.m_128405_("CustomModelData", this.butterflyIndex);
    }

    public void m_5553_(@Nullable Entity entity) {
        ItemStack stack = new ItemStack((ItemLike)this.itemRegistry.getButterflyScrolls().get(this.butterflyIndex).get());
        this.m_19983_(stack);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        int data = (this.f_31699_.m_122411_() & 0xFFFF) << 16 | this.butterflyIndex & 0xFFFF;
        return new ClientboundAddEntityPacket((Entity)this, data, this.m_31748_());
    }

    public int getButterflyIndex() {
        return this.butterflyIndex;
    }

    public int m_7068_() {
        return 14;
    }

    public int m_7076_() {
        return 10;
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12015_, 1.0f, 1.0f);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.m_6022_(Direction.m_122376_((int)tag.m_128445_("Facing")));
        if (tag.m_128441_("CustomModelData")) {
            this.butterflyIndex = tag.m_128451_("CustomModelData");
        }
    }

    protected void m_7087_() {
        if (this.f_31699_ != null) {
            double x = (double)this.f_31698_.m_123341_() + 0.5 - (double)this.f_31699_.m_122429_() * 0.46875;
            double y = (double)this.f_31698_.m_123342_() + 0.5 - (double)this.f_31699_.m_122430_() * 0.46875;
            double z = (double)this.f_31698_.m_123343_() + 0.5 - (double)this.f_31699_.m_122431_() * 0.46875;
            this.m_20343_(x, y, z);
            double width = this.m_7076_();
            double height = this.m_7068_();
            double breadth = this.m_7076_();
            Direction.Axis axis = this.f_31699_.m_122434_();
            switch (axis) {
                case X: {
                    width = 1.0;
                    break;
                }
                case Y: {
                    height = 1.0;
                    break;
                }
                case Z: {
                    breadth = 1.0;
                    break;
                }
            }
            this.m_20011_(new AABB(x - (width /= 32.0), y - (height /= 32.0), z - (breadth /= 32.0), x + width, y + height, z + breadth));
        }
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        int data = packet.m_131509_();
        int direction = data >> 16 & 0xFFFF;
        this.butterflyIndex = data & 0xFFFF;
        this.m_6022_(Direction.m_122376_((int)direction));
    }

    public void setButterflyIndex(int index) {
        this.butterflyIndex = index;
    }

    protected void m_6022_(@NotNull Direction direction) {
        this.f_31699_ = direction;
        this.m_146926_(0.0f);
        this.m_146922_(this.f_31699_.m_122416_() * 90);
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_7087_();
    }

    private ButterflyScroll(EntityType<? extends ButterflyScroll> entityType, Level level) {
        super(entityType, level);
    }
}

